local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local ColorChange = {}
ColorChange.Do = 0;
ColorChange.Queue = 310;

function ColorChange:Initialize(host, size)
  local regionType = {
    uiType = "Combo",
    value = {
      Global = 1
    }
  }
  local replaceType = {
    uiType = "Combo",
    value = {
      Huv = 1,
      Huv_Lightness = 2,
      Huv_Saturation = 3,
      Huv_Lightness_Saturation = 4,
      --Debug = 5,
    }
  }
  local color_selector = {
      uiType = "ColorSelector",
  }
  local drag_float_min_max = {
      uiType = "DragFloatMinMax",
      min=0,
      max=1,
  }
  self.region = mathfunction.vector1(1.0);
  self.replaceMode = mathfunction.vector1(1.0);
  self.softenThreshold = mathfunction.vector1(0.3);
  self.sourceColor = mathfunction.vector4(0.96, 0.99, 0.97, 1);
  self.targetColor = mathfunction.vector4(1, 0, 0, 1);
  self.huv = mathfunction.vector1(0.1);
  self.saturation = mathfunction.vector1(0.5);
  self.lightness = mathfunction.vector1(0.5);
  self.showMask = false;


  self.THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"THRESHOLD");
  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "TARGETSIZE");
  self.SOURCE_COLOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"SOURCE_COLOR");
  self.TARGET_COLOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "TARGET_COLOR");
  self.REPLACE_MODE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "REPLACE_MODE");
  self.HUV = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "HUV");
  self.SATURATION = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "SATURATION");
  self.LIGHTNESS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "LIGHTNESS");
  self.SHOW_MASK = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "SHOW_MASK");

  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/color_change.material");
  self.Do = host:CreateRenderObject(pathout);

  self.Do:SetParameter(self.TARGETSIZE,size);
  self.Do:SetParameter(self.THRESHOLD, self.softenThreshold);
  self.Do:SetParameter(self.SOURCE_COLOR, mathfunction.vector3(self.sourceColor:x(), self.sourceColor:y(), self.sourceColor:z()));
  self.Do:SetParameter(self.TARGET_COLOR, mathfunction.vector3(self.targetColor:x(), self.targetColor:y(), self.targetColor:z()));
  self.Do:SetParameter(self.REPLACE_MODE, self.replaceMode);
  self.Do:SetParameter(self.HUV, self.huv);
  self.Do:SetParameter(self.SATURATION, self.saturation);
  self.Do:SetParameter(self.LIGHTNESS, self.lightness);
  -- self.Do:SetParameter(self.SHOW_MASK, self.showMask);
  if self.showMask then
    self.Do:SetParameter(self.SHOW_MASK, mathfunction.vector1(1));
  else
    self.Do:SetParameter(self.SHOW_MASK, mathfunction.vector1(0));
  end

  host:RegisterScriptParameter(self, "region", regionType);
  host:RegisterScriptParameter(self, "replaceMode", replaceType);
  host:RegisterScriptParameter(self, "softenThreshold", drag_float_min_max);
  host:RegisterScriptParameter(self, "sourceColor", color_selector);
  host:RegisterScriptParameter(self, "targetColor", color_selector);
  host:RegisterScriptParameter(self, "huv", drag_float_min_max);
  host:RegisterScriptParameter(self, "saturation", drag_float_min_max);
  host:RegisterScriptParameter(self, "lightness", drag_float_min_max);
  host:RegisterScriptParameter(self, "showMask");

  return self.Queue;
end



function ColorChange:Resizeview(size)
  self.Do:SetParameter(self.TARGETSIZE,size);
end

function ColorChange:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  self.Do:SetParameter(self.THRESHOLD, self.softenThreshold);
  self.Do:SetParameter(self.SOURCE_COLOR, mathfunction.vector3(self.sourceColor:x(), self.sourceColor:y(), self.sourceColor:z()));
  self.Do:SetParameter(self.TARGET_COLOR, mathfunction.vector3(self.targetColor:x(), self.targetColor:y(), self.targetColor:z()));
  self.Do:SetParameter(self.REPLACE_MODE, self.replaceMode);
  self.Do:SetParameter(self.HUV, self.huv);
  self.Do:SetParameter(self.SATURATION, self.saturation);
  self.Do:SetParameter(self.LIGHTNESS, self.lightness);
  --self.Do:SetParameter(self.SHOW_MASK, self.showMask);
  if self.showMask then
    self.Do:SetParameter(self.SHOW_MASK, mathfunction.vector1(1));
  else
    self.Do:SetParameter(self.SHOW_MASK, mathfunction.vector1(0));
  end
  self.Do:Draw(pipeline);
end

return ColorChange;