local apollocore = require "apollocore"
local EventDispatcher = require "bluecore.eventdispatcher"
local BD = require "bluecore.bluedefined"
local cv = require "computervisionfunction"
local mf = require "mathfunction"

local gStructDataFunction = {}

--[[local allCVTypes = cv.CatFaceComponent:GetAllAvailableCVType();
for k,v in pairs(allCVTypes) do
  EventDispatcher:RegisterEvent(cv.CatFaceComponent:GetTypeName(), k);
end]]--
local _fNativeUpdate = apollocore.IComponent.Update;

local gLastEvent = {}
local _fNativeDestroy = apollocore.IComponent.Destroy;
rawset(cv.CatFaceComponent, "Destroy", function(self)
  local staticID =  self:GetContentPath();
  --for id, _ in pairs(gLastEvent) do
  --  ERROR("Recognition LastEvent staticID: "..tostring(id))
  --end
  gLastEvent[staticID] = nil
  _fNativeDestroy(self);
end);

rawset(cv.CatFaceComponent, "ResetCached", function(self)
  local staticID =  self:GetContentPath();
  gLastEvent[staticID] = nil
end);

local _UpdateFunc = function(self, def)
  _fNativeUpdate(self,def);

  local staticID =  self:GetContentPath();
  -- 只有有这个Comp的监听者才分发
  if EventDispatcher:HasCompListener(staticID) then

    local lastEvents = gLastEvent[staticID];
    gLastEvent[staticID] = nil
    local currentEvents = {}
    local results = self:GetResult();
    if next(results) ~= nil then
      for k, v in pairs(results) do
        -- 只有有这个事件的监听者才分发
        if EventDispatcher:HasEventListener(staticID, k) then
          -- 只过滤事件 具体哪个人的由事件节点过滤
          local event = {
            staticID = staticID;
            eventType = k;
          };
          if gStructDataFunction[k] ~= nil then
            event.params = gStructDataFunction[k](self, v);
          else
            event.params = v;
          end

          if lastEvents and lastEvents[k] then
            lastEvents[k] = false
          end
          currentEvents[k] = true
          EventDispatcher:PushEvent(event);

        end

        -- 人脸事件,需要另外判断(但是不struct数据),是否有监听人脸事件(虚拟)
        if k == cv.CatFaceComponent.cvCatface then
          local HAS_FACE_EVENT = BD.Event.VirtualEvent.HasCat
          if EventDispatcher:HasEventListener(staticID, HAS_FACE_EVENT) then
            local params = self:_StructFaceIdData(v);
            if params ~= nil and next(params) ~= nil then
              local event = {
                staticID = staticID;
                eventType = HAS_FACE_EVENT;
                params = params -- 人脸列表
              };

              if lastEvents and lastEvents[HAS_FACE_EVENT] then
                lastEvents[HAS_FACE_EVENT] = false
              end
              currentEvents[HAS_FACE_EVENT] = true
              EventDispatcher:PushEvent(event);
            end
          end
        end
      end
    end

    gLastEvent[staticID] = currentEvents;

    if lastEvents then
      for eventType, flag in pairs(lastEvents) do
        if flag then -- 代表上次update有这个事件 这次update没有这个事件(代表没有一个人脸)
          local event = {
            staticID = staticID;
            eventType = eventType;
            params = nil, -- 代表当前帧这个事件
          };
          EventDispatcher:PushEvent(event);
        end
      end
    end

  else
    gLastEvent[staticID] = nil -- may not recycle memory ?
  end
end
rawset(cv.CatFaceComponent, "Update", _UpdateFunc);


function cv.CatFaceComponent:_StructFaceIdData(cvCatfaceArray)

  if cvCatfaceArray == nil then
    return
  end

  local faceCount = #cvCatfaceArray;
  if faceCount == 0 then
    return
  end

  local formatFaceArray = {}
  for faceId = 1, faceCount do
    table.insert(formatFaceArray, faceId)
  end

  return formatFaceArray

end
