#DEFPARAMS
MV_FORCE_SCALE = {"MV_FORCE_SCALE", FLOAT, "1.0"},
MOTION_VECTOR  = {"MOTION_VECTOR", TEXTURE2D, "MOTION_VECTOR"},
FORCE_TARGET   = {"FORCE_TARGET", TEXTURE2D, "FORCE_TARGET"},
FLOAT_MIN      = {"FLOAT_MIN", FLOAT, "-100.0"},
FLOAT_MAX      = {"FLOAT_MAX", FLOAT, "100.0"},
WIND_FIELD     = {"WIND_FIELD", VEC2, "0.0, 0.0"},
#END

#DEFTAG
ShaderName  = "ExtForceStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

float     MV_FORCE_SCALE;
Texture2D MOTION_VECTOR;
Texture2D FORCE_TARGET;
SamplerState MOTION_VECTOR_Sampler;
SamplerState FORCE_TARGET_Sampler;
float     FLOAT_MIN;
float     FLOAT_MAX;
float2    WIND_FIELD;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 motion_vector = 2.0 * (MOTION_VECTOR.Sample(MOTION_VECTOR_Sampler, i.uv).xy - float2(0.5, 0.5)); // [0, 1] -> [-1, 1]
    float2 force         = MV_FORCE_SCALE * motion_vector + WIND_FIELD;

    float4 result  = float4(FORCE_TARGET.Sample(FORCE_TARGET_Sampler, i.uv).xy, 0.0, 1.0);
    float  range   = FLOAT_MAX - FLOAT_MIN;
    result.xy = result.xy + force / range;
    mainColor = result;
}
ENDCG
#END