#DEFPARAMS
COLOR      = {"COLOR", TEXTURE2D, "COLOR"},
CUR_FRAME  = {"CUR_FRAME", TEXTURE2D, "CUR_FRAME"},
BLEND_MODE = {"BLEND_MODE", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName  = "BlendStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "blendfunc.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D COLOR;
Texture2D CUR_FRAME;
SamplerState COLOR_Sampler;
SamplerState CUR_FRAME_Sampler;
float     BLEND_MODE;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float4 color = COLOR.Sample(COLOR_Sampler, i.uv);
    float4 base  = CUR_FRAME.Sample(CUR_FRAME_Sampler, i.uv);
    int blend_mode   = int(BLEND_MODE + 0.5);
    float3 blend_color = blend(blend_mode, base, color);
    mainColor = float4(blend_color, color.a);
}
ENDCG
#END