

#DEFPARAMS

#END

#DEFTAG
ShaderName = "Toon"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 TARGETSIZE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}


float3 rgb2xyz( float3 rgbcolor ) {
    float3 xyzcolor=float3
    (
        (( rgbcolor.r > 0.04045 ) ? pow( ( rgbcolor.r + 0.055 ) / 1.055, 2.4 ) : rgbcolor.r / 12.92),
        (( rgbcolor.g > 0.04045 ) ? pow( ( rgbcolor.g + 0.055 ) / 1.055, 2.4 ) : rgbcolor.g / 12.92),
        (( rgbcolor.b > 0.04045 ) ? pow( ( rgbcolor.b + 0.055 ) / 1.055, 2.4 ) : rgbcolor.b / 12.92)
    );
    return mul
    (
        100.0 * xyzcolor,
        float3x3( 0.4124, 0.3576, 0.1805, 0.2126, 0.7152, 0.0722,0.0193, 0.1192, 0.9505 )
    );
}
float3 xyz2Lab( float3 xyzcolor )
{
    float3 tem = xyzcolor / float3( 95.047, 100, 108.883 );
    float3 v = float3
    (
        ( tem.x > 0.008856 ) ? pow( tem.x, 1.0 / 3.0 ) : ( 7.787 * tem.x ) + ( 16.0 / 116.0 ),
        ( tem.y > 0.008856 ) ? pow( tem.y, 1.0 / 3.0 ) : ( 7.787 * tem.y ) + ( 16.0 / 116.0 ),
        ( tem.z > 0.008856 ) ? pow( tem.z, 1.0 / 3.0 ) : ( 7.787 * tem.z ) + ( 16.0 / 116.0 )
    );
    return float3(( 116.0 * v.y ) - 16.0, 500.0 * ( v.x - v.y ), 200.0 * ( v.y - v.z ));
}
float3 rgb2Lab(float3 rgbcolor)
{
    float3 lab = xyz2Lab( rgb2xyz( rgbcolor ) );
    return float3( lab.x / 100.0, 0.5 + 0.5 * ( lab.y / 127.0 ), 0.5 + 0.5 * ( lab.z / 127.0 ));
}
float3 lab2xyz( float3 c )
{
    float fy = ( c.x + 16.0 ) / 116.0;
    float fx = c.y / 500.0 + fy;
    float fz = fy - c.z / 200.0;
    return float3
    (
        95.047 * (( fx > 0.206897 ) ? fx * fx * fx : ( fx - 16.0 / 116.0 ) / 7.787),
        100.000 * (( fy > 0.206897 ) ? fy * fy * fy : ( fy - 16.0 / 116.0 ) / 7.787),
        108.883 * (( fz > 0.206897 ) ? fz * fz * fz : ( fz - 16.0 / 116.0 ) / 7.787)
    );
}

float3 xyz2rgb( float3 c ) {
    float3 v = mul(c / 100.0, float3x3(3.2406, -1.5372, -0.4986, -0.9689, 1.8758, 0.0415, 0.0557, -0.2040, 1.0570 ));
    float3 r;
    r.x = ( v.r > 0.0031308 ) ? (( 1.055 * pow( v.r, ( 1.0 / 2.4 ))) - 0.055 ) : 12.92 * v.r;
    r.y = ( v.g > 0.0031308 ) ? (( 1.055 * pow( v.g, ( 1.0 / 2.4 ))) - 0.055 ) : 12.92 * v.g;
    r.z = ( v.b > 0.0031308 ) ? (( 1.055 * pow( v.b, ( 1.0 / 2.4 ))) - 0.055 ) : 12.92 * v.b;
    return r;
}
float3 lab2rgb(float3 c) {
    return xyz2rgb( lab2xyz( float3(100.0 * c.x, 2.0 * 127.0 * (c.y - 0.5), 2.0 * 127.0 * (c.z - 0.5)) ) );
}
void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 size = TARGETSIZE;
    float2 d = 1.0 / size;
    float3 c = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv).xyz;
    c= clamp(rgb2Lab( c), 0.0, 1.0);
    float cuantized = floor(c.x*8.0+0.5) /8.0;
    float3 cb = float3(cuantized, c.yz);
    mainColor = float4( clamp(lab2rgb(clamp(cb, 0.0, 1.0)), 0.0, 1.0), 1.0 );
}
ENDCG
#END
