

#DEFPARAMS
_A = { "A", FLOAT, "278.5085"},
_B = { "B", FLOAT, "10.7772"},
_C = { "C", FLOAT, "293.6045"},
_D = { "D", FLOAT, "88.7122"},
_E = { "E", FLOAT, "80.6889"},
#END

#DEFTAG
ShaderName = "tonemappingACES"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float3 _Input;
float2 _Output;
float _A;
float _B;
float _C;
float _D;
float _E;



#define ACEScc_MIDGRAY  0.4135884
#define FLT_MAX         3.402823466e+38 // Maximum representable floating-point number
#define HALF_MAX        65504.0
#define PI              3.14159265359
static const half RRT_GLOW_GAIN       = 0.05;
static const half RRT_GLOW_MID        = 0.08;
static const half RRT_RED_SCALE       = 0.82;
static const half RRT_RED_PIVOT       = 0.03;
static const half RRT_RED_HUE         = 0.0;
static const half RRT_RED_WIDTH       = 135.0;
static const half RRT_SAT_FACTOR      = 0.96;
static const half DIM_SURROUND_GAMMA  = 0.9811;
static const half ODT_SAT_FACTOR      = 0.93;


static const half3 AP1_RGB2Y = half3(0.272229, 0.674082, 0.0536895);

static const half3x3 sRGB_2_AP0 = {
    0.4397010, 0.3829780, 0.1773350,
    0.0897923, 0.8134230, 0.0967616,
    0.0175440, 0.1115440, 0.8707040
};

static const half3x3 AP0_2_AP1_MAT = {
     1.4514393161, -0.2365107469, -0.2149285693,
    -0.0765537734,  1.1762296998, -0.0996759264,
     0.0083161484, -0.0060324498,  0.9977163014
};

static const half3x3 AP1_2_XYZ_MAT = {
     0.6624541811, 0.1340042065, 0.1561876870,
     0.2722287168, 0.6740817658, 0.0536895174,
    -0.0055746495, 0.0040607335, 1.0103391003
};

static const half3x3 XYZ_2_AP1_MAT = {
     1.6410233797, -0.3248032942, -0.2364246952,
    -0.6636628587,  1.6153315917,  0.0167563477,
     0.0117218943, -0.0082844420,  0.9883948585
};

static const half3x3 D60_2_D65_CAT = {
     0.98722400, -0.00611327, 0.0159533,
    -0.00759836,  1.00186000, 0.0053302,
     0.00307257, -0.00509595, 1.0816800
};

static const half3x3 XYZ_2_REC709_MAT = {
     3.2409699419, -1.5373831776, -0.4986107603,
    -0.9692436363,  1.8759675015,  0.0415550574,
     0.0556300797, -0.2039769589,  1.0569715142
};

float FastSign(float x)
{
    return saturate(x * FLT_MAX + 0.5) * 2.0 - 1.0;
}

half rgb_2_saturation(half3 rgb)
{
    const half TINY   = 1e-4;
    half mi           = min(min(rgb.r, rgb.g), rgb.b);
    half ma           = max(max(rgb.r, rgb.g), rgb.b);
    return (max(ma, TINY) - max(mi, TINY)) / max(ma, 1e-2);
}

half rgb_2_yc(half3 rgb)
{
    const half ycRadiusWeight = 1.75;
    half r                    = rgb.x;
    half g                    = rgb.y;
    half b                    = rgb.z;
    half chroma               = sqrt(b * (b - g) + g * (g - r) + r * (r - b));
    return (b + g + r + ycRadiusWeight * chroma) / 3.0;
}

half sigmoid_shaper(half x)
{
    // Sigmoid function in the range 0 to 1 spanning -2 to +2.
    half t            = max(1.0 - abs(x / 2.0), 0.0);
    half y            = 1.0 + FastSign(x) * (1.0 - t * t);
    return y / 2.0;
}

half glow_fwd(half ycIn, half glowGainIn, half glowMid)
{
    half glowGainOut;
    if (ycIn <= 2.0 / 3.0 * glowMid)
        glowGainOut = glowGainIn;
    else if (ycIn >= 2.0 * glowMid)
        glowGainOut = 0.0;
    else
        glowGainOut = glowGainIn * (glowMid / ycIn - 1.0 / 2.0);
    return glowGainOut;
}

half rgb_2_hue(half3 rgb)
{
    // Returns a geometric hue angle in degrees (0-360) based on RGB values.
    // For neutral colors, hue is undefined and the function will return a quiet NaN value.
    half hue;
    if (rgb.x == rgb.y && rgb.y == rgb.z)
        hue = 0.0; // RGB triplets where RGB are equal have an undefined hue
    else
        hue = (180.0 / PI) * atan2(sqrt(3.0) * (rgb.y - rgb.z), 2.0 * rgb.x - rgb.y - rgb.z);
    if (hue < 0.0) hue = hue + 360.0;
    return hue;
}

half center_hue(half hue, half centerH)
{
    half hueCentered = hue - centerH;
    if (hueCentered < -180.0) hueCentered = hueCentered + 360.0;
    else if (hueCentered > 180.0) hueCentered = hueCentered - 360.0;
    return hueCentered;
}

half3 ACES_to_ACEScg(half3 x)
{
    return mul(AP0_2_AP1_MAT, x);
}

half3 XYZ_2_xyY(half3 XYZ)
{
    half divisor = max(dot(XYZ, (1.0).xxx), 1e-4);
    return half3(XYZ.xy / divisor, XYZ.y);
}

half3 xyY_2_XYZ(half3 xyY)
{
    half m = xyY.z / max(xyY.y, 1e-4);
    half3 XYZ = half3(xyY.xz, (1.0 - xyY.x - xyY.y));
    XYZ.xz *= m;
    return XYZ;
}

half3 darkSurround_to_dimSurround(half3 linearCV)
{
    half3 XYZ       = mul(AP1_2_XYZ_MAT, linearCV);
    half3 xyY       = XYZ_2_xyY(XYZ);
    xyY.z           = clamp(xyY.z, 0.0, HALF_MAX);
    xyY.z           = pow(xyY.z, DIM_SURROUND_GAMMA);
    XYZ             = xyY_2_XYZ(xyY);
    return mul(XYZ_2_AP1_MAT, XYZ);
}

float3 AcesTonemap(float3 aces, float _A, float _B, float _C, float _D, float _E)
{
  // --- Glow module --- //
  float saturation  = rgb_2_saturation(aces);
  float ycIn        = rgb_2_yc(aces);
  float s           = sigmoid_shaper((saturation - 0.4) / 0.2);
  float addedGlow   = 1.0 + glow_fwd(ycIn, RRT_GLOW_GAIN * s, RRT_GLOW_MID);
  aces *= addedGlow;

  // --- Red modifier --- //
  float hue         = rgb_2_hue(aces);
  float centeredHue = center_hue(hue, RRT_RED_HUE);
  float hueWeight;
  {
    //hueWeight = cubic_basis_shaper(centeredHue, RRT_RED_WIDTH);
    hueWeight       = smoothstep(0.0, 1.0, 1.0 - abs(2.0 * centeredHue / RRT_RED_WIDTH));
    hueWeight *= hueWeight;
  }
  aces.r += hueWeight * saturation * (RRT_RED_PIVOT - aces.r) * (1.0 - RRT_RED_SCALE);

  // --- ACES to RGB rendering space --- //
  float3 acescg = max(0.0, ACES_to_ACEScg(aces));

  // --- Global desaturation --- //
  acescg          = lerp(dot(acescg, AP1_RGB2Y).xxx, acescg, RRT_SAT_FACTOR.xxx);
  //const float a = 278.5085;
  //const float b = 10.7772;
  //const float c = 293.6045;
  //const float d = 88.7122;
  //const float e = 80.6889;
  float3 x        = acescg;
  float3 rgbPost  = (x * (_A * x + _B)) / (x * (_C * x + _D) + _E);

  // Apply gamma adjustment to compensate for dim surround
  float3 linearCV = darkSurround_to_dimSurround(rgbPost);

  // Apply desaturation to compensate for luminance difference  
  linearCV        = lerp(dot(linearCV, AP1_RGB2Y).xxx, linearCV, ODT_SAT_FACTOR.xxx);

  // Convert to display primary encoding
  // Rendering space RGB to XYZ
  float3 XYZ      = mul(AP1_2_XYZ_MAT, linearCV);

  // Apply CAT from ACES white point to assumed observer adapted white point
  XYZ             = mul(D60_2_D65_CAT, XYZ);

  // CIE XYZ to display primaries
  linearCV        = mul(XYZ_2_REC709_MAT, XYZ);
  
  return linearCV;
}


float3 ColorGradeHDR(float3 color, float _A, float _B, float _C, float _D, float _E)
{
  float3 aces     = mul(sRGB_2_AP0, color); 
  // Tonemap ODT(RRT(aces))
  float3 linearCV = AcesTonemap(aces, _A, _B, _C, _D, _E);

  return linearCV;
}

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
  // sample the texture
  float4 mainColor  = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);

  outColor          = mainColor;
  outColor.xyz      = ColorGradeHDR(outColor.xyz, _A, _B, _C, _D, _E);  
}
ENDCG
#END
