#SHADER_DEFINE SmoothblendVertex

    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  SmoothblendFragment

    FUNCTION_INPUT =
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { TEXTURE_ORIGIN,            NONE,      TEXTURE2D,     "in_OriginTexture"},
        { TEXTURE_BLUR,              NONE,      TEXTURE2D,       "in_BlurTexture"},
        { TEXTURE_MASK,              NONE,      TEXTURE2D,       "in_MaskTexture"},
        { UNIFORM_INTENSITY,         MEDIUM,    FLOAT,                "intensity"},
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,         "in_TexCoordinate" },
    }

#SHADER_CODE
    lowp vec4 sourceColor = texture2D(in_OriginTexture, in_TexCoordinate);
    lowp vec4 blurColor = texture2D(in_BlurTexture, in_TexCoordinate);
    lowp vec4 highPassBlurColor = texture2D(in_DiffuseTexture, in_TexCoordinate);
    lowp vec4 MaskColor = texture2D(in_MaskTexture, in_TexCoordinate);
    lowp vec3 W = vec3(0.2125,0.7154,0.0721);
    // 蓝色通道
    mediump float value = clamp((min(sourceColor.b, blurColor.b) - 0.2) * 5.0, 0.0, 1.0);
    // 亮度
    mediump float l = dot(sourceColor.rgb,W);
    l = 1.0 - exp((l-1.0)*8.0);
    // 找到模糊之后RGB通道的最大值
    mediump float maxChannelColor = max(max(highPassBlurColor.r, highPassBlurColor.g), highPassBlurColor.b);
    // 计算当前的强度
    mediump float currentIntensity = (1.0 - maxChannelColor / (maxChannelColor+0.075)) * value * intensity * l;
    currentIntensity = (1.0 - exp(-currentIntensity*5.0))*currentIntensity;

    lowp vec3 resultColor = mix(sourceColor.rgb, blurColor.rgb, currentIntensity*MaskColor.g);


    // 输出颜色
    gl_FragColor = vec4(resultColor, 1.0);
    //gl_FragColor = vec4(blurColor,1.0);
    //gl_FragColor = MaskColor;
#END_CODE
#END_DEFINE
