//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////
//#include "functions/helperfunc.function"
//#include "functions/noise4d.function"
#SHADER_DEFINE EmitterVertexCpu

	FUNCTION_INPUT = 
	{
    { SYSTEM_TIME,		HIGH,	FLOAT,	"in_Time" },
    { ATTRIBUTE_NORMAL, HIGH, VEC4, "in_Speed_Borntime"},
    { ATTRIBUTE_COORDNATE1, HIGH, VEC4, "in_Rot_Lifetime"},
    { ATTRIBUTE_COORDNATE2, HIGH, VEC3, "in_Size_Distrubance_Stretch"},
	{ ATTRIBUTE_POSITION,		MEDIUM,	VEC3,	"in_Center" },
    { PARTICLE_GLOBAL_OFFSET,		HIGH,	VEC3,		"in_GlobalOffset" },
    { PARTICLE_GLOBAL_SCALE,    HIGH, VEC3,   "in_GlobalScale" },
    { ATTRIBUTE_COLOR0,		MEDIUM,	VEC4,	"in_ParticleColor" },
    { ATTRIBUTE_COORDNATE3,			MEDIUM,	VEC2,		"in_Offset" },
	
  
	}

	FUNCTION_OUTPUT = 
	{
		{ LOCALSPACE_POSITION,		MEDIUM,	VEC3,	"out_NewCenter" },
    { PARTICLE_COLOR,	LOW,	VEC4,	"out_SurfaceColor" },
    { PARTICLE_OFFEET,		MEDIUM,	VEC3,	"out_Offset" },
	}

#SHADER_CODE
  vec3 out_NewCenter = in_Center + in_GlobalOffset;
  vec4 out_SurfaceColor = in_ParticleColor;
  //vec3 speed = in_Speed_Borntime.xyz;
  //vec3 speedNormlized = normalize(speed.xyz + vec3(0.0001,0.0001,0.0001));  //to avoid speed value is zero
  float borntime = in_Speed_Borntime.w;
  float lifetime = in_Rot_Lifetime.w;
  float distrubance = in_Size_Distrubance_Stretch.y;
  float emittersize = in_Size_Distrubance_Stretch.x;
  //float stretch = in_Size_Distrubance_Stretch.z;
  
  
  float angleX = in_Rot_Lifetime.x;
  float angleY = in_Rot_Lifetime.y;
  float angleZ = in_Rot_Lifetime.z;
  
  float sx = sin(angleX);
	float cx = cos(angleX);

	float sy = sin(angleY);
	float cy = cos(angleY);

                   
  float sz = sin(angleZ);
	float cz = cos(angleZ);

  

  mat3 rotMatrix = mat3(cz * cy, cz * sy * sx - cx * sz, sz * sx + cz * cx * sy,
                        cy * sz, cz * cx + sz * sy * sx, cx * sz  - cz * sx,
                        -sy, cy * sx, cy * cx);

  
 //first stretch along the speed  
 //mat2 stretchrotation = mat2(-speedNormlized.y,-speedNormlized.x,
 //                     speedNormlized.x,-speedNormlized.y); 
 //vec2 offsetforstretch = in_Offset;
  

  //offsetforstretch.y = offsetforstretch.y - emittersize;
  //float stretch_ratio = stretch;
  //offsetforstretch.y *= stretch_ratio;
  //offsetforstretch.y = offsetforstretch.y + emittersize;
  //offsetforstretch = offsetforstretch * stretchrotation;
  
  vec3 out_Offset = vec3(in_Offset,0.0);
  out_Offset = out_Offset * emittersize * in_GlobalScale;
  out_Offset = out_Offset * rotMatrix;
  
  
  
  //distrubance noise
  vec4 noseCoord = vec4(out_Offset,(in_Time - borntime) / lifetime);
  //vec3 noise = getNoiseOffset(noseCoord);
  float pase = length(in_Center + out_Offset) * in_Time;
  float noise = cos(pase);
  out_Offset += out_Offset * ( distrubance * noise);
  //out_Offset.z = 0.0;
  

#END_CODE
#END_DEFINE

#SHADER_DEFINE EmitterVertexCpuFollow

	FUNCTION_INPUT =
	{
    { SYSTEM_TIME,		HIGH,	FLOAT,	"in_Time" },
    { ATTRIBUTE_NORMAL, HIGH, VEC4, "in_Speed_Borntime"},
    { ATTRIBUTE_COORDNATE1, HIGH, VEC4, "in_Rot_Lifetime"},
    { ATTRIBUTE_COORDNATE2, HIGH, VEC4, "in_Size_Distrubance_Stretch"},
	{ ATTRIBUTE_POSITION,		MEDIUM,	VEC3,	"in_Center" },
    { PARTICLE_GLOBAL_OFFSET,		HIGH,	VEC3,		"in_GlobalOffset" },
    { PARTICLE_GLOBAL_SCALE,    HIGH, VEC3,   "in_GlobalScale" },
    { PARTICLE_GLOBAL_ROTATION_MATRIX,    HIGH, MAT4,   "in_GlobalRotation" },
    { ATTRIBUTE_COLOR0,		MEDIUM,	VEC4,	"in_ParticleColor" },
    { ATTRIBUTE_COORDNATE3,			MEDIUM,	VEC2,		"in_Offset" },

	}

	FUNCTION_OUTPUT =
	{
		{ LOCALSPACE_POSITION,		MEDIUM,	VEC3,	"out_NewCenter" },
        { PARTICLE_COLOR,	LOW,	VEC4,	"out_SurfaceColor" },
        { PARTICLE_OFFEET,		MEDIUM,	VEC3,	"out_Offset" },
	}

#SHADER_CODE
  vec4 origin = vec4(0,0,0,1);
  origin = in_GlobalRotation * origin;

  vec3 out_NewCenter = origin.xyz + in_GlobalOffset;

  vec4 out_SurfaceColor = in_ParticleColor;
  //vec3 speed = in_Speed_Borntime.xyz;
  //vec3 speedNormlized = normalize(speed.xyz + vec3(0.0001,0.0001,0.0001));  //to avoid speed value is zero
  float borntime = in_Speed_Borntime.w;
  float lifetime = in_Rot_Lifetime.w;
  float distrubance = in_Size_Distrubance_Stretch.y;
  float emittersize = in_Size_Distrubance_Stretch.x;
  //float stretch = in_Size_Distrubance_Stretch.z;


  float angleX = in_Rot_Lifetime.x;
  float angleY = in_Rot_Lifetime.y;
  float angleZ = in_Rot_Lifetime.z;

  float sx = sin(angleX);
	float cx = cos(angleX);

	float sy = sin(angleY);
	float cy = cos(angleY);


  float sz = sin(angleZ);
	float cz = cos(angleZ);



  mat3 rotMatrix = mat3(cz * cy, cz * sy * sx - cx * sz, sz * sx + cz * cx * sy,
                        cy * sz, cz * cx + sz * sy * sx, cx * sz  - cz * sx,
                        -sy, cy * sx, cy * cx);


 //first stretch along the speed
 //mat2 stretchrotation = mat2(-speedNormlized.y,-speedNormlized.x,
 //                     speedNormlized.x,-speedNormlized.y);
 //vec2 offsetforstretch = in_Offset;


  //offsetforstretch.y = offsetforstretch.y - emittersize;
  //float stretch_ratio = stretch;
  //offsetforstretch.y *= stretch_ratio;
  //offsetforstretch.y = offsetforstretch.y + emittersize;
  //offsetforstretch = offsetforstretch * stretchrotation;

  vec3 out_Offset = vec3(in_Offset,0.0);
  out_Offset = out_Offset * emittersize * in_GlobalScale;
  out_Offset = out_Offset * rotMatrix;



  //distrubance noise
  vec4 noseCoord = vec4(out_Offset,(in_Time - borntime) / lifetime);
  //vec3 noise = getNoiseOffset(noseCoord);
  float pase = length(in_Center + out_Offset) * in_Time;
  float noise = cos(pase);
  out_Offset += out_Offset * ( distrubance * noise);
  //out_Offset.z = 0.0;


#END_CODE
#END_DEFINE