#SHADER_DEFINE ClipartBlendScreenVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE ClipartBlendScreenFragment

    FUNCTION_INPUT = 
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { TEXTURE_CLIPART,           NONE,      TEXTURE2D,   "in_ClipartTexture" },
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,        "in_TexCoordinate"  },
    }

#SHADER_CODE
    
    vec4 dstColor = texture2D(in_DiffuseTexture, in_TexCoordinate);
    vec4 srcColor = texture2D(in_ClipartTexture, in_TexCoordinate);

    gl_FragColor = vec4(1.0 - (1.0 - srcColor.rgb) * (1.0 - dstColor.rgb), 1.0);

#END_CODE
#END_DEFINE







