

#DEFPARAMS
TEXTURE_DIFFUSE = { "tex", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "Skeleton3B"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGB
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 position : POSITION;
	float3 normal : NORMAL;
	float4 tangent : TANGENT;
	float2 uv : TEXCOORD0;
	float4 BoneIndex : BLENDINDICES;
	float4 Boneweight : BLENDWEIGHT;
};

struct v2f
{
	float4 position : SV_POSITION;
	float3 normal : NORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
	float4 index : BLENDINDICES;
	float4 weight : BLENDWEIGHT;
	float4 positionWS : TEXCOORD1;
	float3 positionCS : TEXCOORD2;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float3x3 LOCALWORLD_ROTATION;

v2f vert(appdata v)
{
	v2f o;

	o.uv = v.uv.xy;

	float3 blendPos = float3(0.0, 0.0, 0.0);
	float3 blendNorm = float3(0.0, 0.0, 0.0);
	float3 blendTangent = float3(0.0, 0.0, 0.0);

	for (int bone = 0; bone < 3; ++bone)
	{
		int idx = int(v.BoneIndex[bone]) * 3;

		float weight = v.Boneweight[bone];

		float4x4 worldMatrix =
		{
			ANIMATION_MATRIX_ARRAY[idx],
			ANIMATION_MATRIX_ARRAY[idx + 1],
			ANIMATION_MATRIX_ARRAY[idx + 2],
			float4(0.0,0.0,0.0,0.0)
		};

		blendPos += mul(worldMatrix, v.position).xyz * weight;

		float3x3 worldRotMtrix = float3x3(worldMatrix[0].xyz,worldMatrix[1].xyz,worldMatrix[2].xyz);
		blendNorm += mul(worldRotMtrix, v.normal.xyz) * weight;

		blendTangent += mul(worldRotMtrix, v.tangent.xyz) * weight;
	}

	blendNorm = normalize(blendNorm);

	o.position = float4(blendPos,1.0);
	o.normal = blendNorm;
	o.tangent = blendTangent;


	o.normal = mul(o.normal.xyz, LOCALWORLD_ROTATION);
	o.tangent =  mul(o.tangent.xyz, LOCALWORLD_ROTATION);
	o.positionWS = mul(o.position, LOCALWORLD_TRANSFORM);
	float4 positionCS = mul(o.positionWS, CAMERA_VIEW);
	o.positionCS = positionCS.xyz / positionCS.w;
	o.position = mul(o.positionWS, CAMERA_VIEWPROJ);
	o.position = UniformNDC(o.position);

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	mainColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
}
ENDCG
#END
