#SHADER_DEFINE SharpenVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			MEDIUM,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
    { PIXEL_OFFSETS,            MEDIUM, VEC2,   "in_Offsets"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ SQUARE_COORDINATE,		  MEDIUM,		VEC2_ARRAY,		"out_SquareCoord", "5" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    
    vec2 out_SquareCoord[5];
    

    out_SquareCoord[0] = vec2(in_TexCoordinate.x , in_TexCoordinate.y - in_Offsets.y);
    out_SquareCoord[1] = vec2(in_TexCoordinate.x - in_Offsets.x , in_TexCoordinate.y);
    out_SquareCoord[2] = in_TexCoordinate.xy;
    out_SquareCoord[3] = vec2(in_TexCoordinate.x + in_Offsets.x , in_TexCoordinate.y);
    out_SquareCoord[4] = vec2(in_TexCoordinate.x , in_TexCoordinate.y + in_Offsets.y); 
     
    
    
#END_CODE
#END_DEFINE


#SHADER_DEFINE SharpenFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { SQUARE_COORDINATE,		  MEDIUM,		VEC2_ARRAY,		"out_SquareCoord", "5" },
    { SHARPNESS,		  HIGH,		FLOAT,		"sharpness"},
	}

#SHADER_CODE
      vec3 textureColor = texture2D(uniCurrentTexture, out_SquareCoord[2]).rgb;
      vec3 leftTextureColor = texture2D(uniCurrentTexture, out_SquareCoord[0]).rgb;
      vec3 rightTextureColor = texture2D(uniCurrentTexture, out_SquareCoord[4]).rgb;
      vec3 topTextureColor = texture2D(uniCurrentTexture, out_SquareCoord[1]).rgb;
      vec3 bottomTextureColor = texture2D(uniCurrentTexture, out_SquareCoord[3]).rgb;
      float centerMultiplier = 1.0 + 4.0 * sharpness;
      float edgeMultiplier = sharpness;
      gl_FragColor = vec4((textureColor * centerMultiplier - (leftTextureColor * edgeMultiplier + rightTextureColor * edgeMultiplier + topTextureColor * edgeMultiplier + bottomTextureColor* edgeMultiplier)), texture2D(uniCurrentTexture, out_SquareCoord[2]).w);
#END_CODE
#END_DEFINE



