

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "maintex" },
_TexOffset = { "uv offset", VEC2, "0.0, 0.0"},
_TexTilling = { "uv tilling", VEC2, "1.0, 1.0"},
_Alpha = {"alpha", FLOATRANGE, "1.0, 1, 0"},
_ScaleX = { "scale_x", FLOAT, "1.0" },
_ScaleY = { "scale_y", FLOAT, "1.0" },
_PosX = { "pos_x", FLOAT, "0.0" },
_PosY = { "pos_y", FLOAT, "0.0" },
#END

#DEFTAG
ShaderName = "sdfbackground"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_ALWAYS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"


struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 _TexOffset;
float2 _TexTilling;
float _Alpha;
float _ScaleX;
float _ScaleY;
float _PosX;
float _PosY;

v2f vert(appdata v)
{
    v2f o;
    float2 in_WorldScale = float2(_ScaleX, _ScaleY);
    float4 cpos = ObjectToClipPos(float4(0,0,0,1));
    float4 pos = float4(v.vertex * in_WorldScale / 1000.0 + cpos.xy/cpos.w + float2(_PosX, _PosY), 0.0, 1.0);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    return o;
}


void frag(in v2f i, out float4 outputColor : SV_Target0)
{
    float4 mainColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,i.uv);
    mainColor.a = mainColor.a * _Alpha;
    outputColor = mainColor;
}
ENDCG
#END
