CGPROGRAM

#include "hair_common.inc"

//SRVs
StructuredBuffer<float4> g_FollowHairRootOffset;


#pragma compute UpdateFollowHair

[numthreads(THREAD_GROUP_SIZE,1,1)]
void UpdateFollowHair(
    uint GIndex : SV_GroupIndex,
    uint3 GId : SV_GroupID,
    uint3 DTid : SV_DispatchThreadID)
{
   
	uint globalStrandIndex, localStrandIndex, globalVertexIndex, localVertexIndex, numVerticesInTheStrand, indexForSharedMem;
	CalcIndicesInVertexLevelMaster(GIndex, GId.x, globalStrandIndex, localStrandIndex, globalVertexIndex, localVertexIndex, numVerticesInTheStrand, indexForSharedMem);


    sharedPos[indexForSharedMem] = g_HairVertexPositions[globalVertexIndex];
    sharedTangent[indexForSharedMem] = g_HairVertexTangents[globalVertexIndex];
    GroupMemoryBarrierWithGroupSync();
 
    for ( uint i = 0; i < g_NumFollowHairsPerGuideHair; i++ )
    {
        int globalFollowVertexIndex = globalVertexIndex + numVerticesInTheStrand * (i + 1);
        int globalFollowStrandIndex = globalStrandIndex + i + 1;
        float factor = g_TipSeparationFactor*((float)localVertexIndex / (float)numVerticesInTheStrand) + 1.0f;
        float3 followPos = sharedPos[indexForSharedMem].xyz  + factor*g_FollowHairRootOffset[globalFollowStrandIndex].xyz;
        g_HairVertexPositions[globalFollowVertexIndex] = float4(followPos, g_HairVertexPositions[globalFollowVertexIndex].w);
        g_HairVertexTangents[globalFollowVertexIndex] = sharedTangent[indexForSharedMem];
    }


}


ENDCG