#DEFPARAMS
MainTex = { "main Color", TEXTURE2D, "white" },
NormalTexture = {"Normal Map", TEXTURE2D, "white"},
SpecularTex = {"Specular Map", TEXTURE2D, "white"},
BRDFTex = {"BRDF Map", TEXTURE2D, "white"},
skybox = {"SkyBox", TEXTURECUBE, "black"},

ShadeColor = {"Shade Color", COLOR, "0.0,0.0,0.0,1.0"},
ShadowColor = {"Shadow Color", COLOR, "0.0,0.0,0.0,1.0"},
SpecularColor = {"Specular Color", COLOR, "0.0,0.0,0.0,1.0"},
RimColor = {"Rim Color", COLOR, "0.0,0.0,0.0,1.0"},
RimPower = {"Rim Pow", FLOAT, "0.5"},

Fresnel = { "Fresnel", FLOAT, "0.5" },
extraShadeRange = { "extraShadeRange", FLOAT, "0.5" },

#END
  
#DEFTAG
ShaderName = "StandardSkin"
RenderQueue = "Opaque"
#END
  
#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
  ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
  SHADOW_COORDS(4)
};

Texture2D MainTex;
Texture2D NormalTexture;
Texture2D SpecularTex;
Texture2D BRDFTex;
TextureCube skybox;
SamplerState MainTex_Sampler;
SamplerState NormalTexture_Sampler;
SamplerState SpecularTex_Sampler;
SamplerState BRDFTex_Sampler;
SamplerState skybox_Sampler;

float4 ShadeColor;
float4 ShadowColor;
float4 SpecularColor;
float4 RimColor;
float RimPower;

float Fresnel;
float extraShadeRange;


v2f vert(appdata v)
{
  COMPUTE_BONE_MATERIX(v);
  v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;
  TRANSFER_SHADOW(o, v.vertex);
	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
    float2 in_Coordinate0 = i.uv;
    float4 in_NormalWS = i.worldnormal;
    float4 in_TangentWS = i.worldtangent;
    float4 in_BinormalWS = i.worldbinormal;

    float atten = SHADOW_ATTEN(i);

    float3 worldPos = float3(in_NormalWS.w, in_TangentWS.w, in_BinormalWS.w);
    float3 viewDir_S = CAMERA_WORLDPOSITION - worldPos.xyz;
    float3 viewDir = normalize(viewDir_S);

    float3 mainNormal = NormalTexture.Sample(NormalTexture_Sampler, in_Coordinate0.xy).xyz;
    float3 groundNormal = mainNormal.xyz * 2.0 - 1.0;

    float3 worldNormal = groundNormal.x * in_TangentWS.xyz + groundNormal.y * in_BinormalWS.xyz
					+ groundNormal.z * in_NormalWS.xyz;
    worldNormal = normalize(worldNormal);

    float3 light1Dir = -(LIGHT_GIVEN_DIRECTION);
    float3 h1 = normalize(viewDir + light1Dir);
    float nv = max(dot(worldNormal, viewDir), 0.0);
    float nh1 = max(dot(worldNormal, h1), 0.0);

    // main color
  float3 mainColor = MainTex.Sample(MainTex_Sampler, in_Coordinate0.xy).xyz;
	mainColor *= mainColor;

    float3 specular = SpecularTex.Sample(SpecularTex_Sampler, in_Coordinate0.xy).xyz;
	float roughness = 1.0 - specular.x;
	float curveness = specular.y;
	float shadowSelfMask = 1.0 - specular.z;

    // diffuse
  float3 diffuse = float3(0.0, 0.0, 0.0);
	float shaowRange = nv / extraShadeRange;
	float diffuseShadow = lerp(1.0, nv, shadowSelfMask);
	float nl1 = dot(worldNormal, light1Dir);
	float nl1Warp = (nl1 * 0.5) + 0.5;

	float2 brdfUV = float2(nl1Warp, curveness);
	float3 brdfColor = BRDFTex.Sample(BRDFTex_Sampler, brdfUV).xyz;
  
	float shadow = atten;
	float3 adjuseColor = lerp(ShadowColor.xyz, brdfColor.xyz, shadow);
	float3 fontLight = adjuseColor * LIGHT_COLOR * mainColor;

  float3 ambientLight =  AMBIENT_COLOR.xyz * mainColor;
  float3 white = float3(1.0, 1.0, 1.0);
	float3 diffuseShadowColor = lerp(ShadeColor.xyz, white.xyz, diffuseShadow);
	float3 outDiffuse = (fontLight + ambientLight) * diffuseShadowColor;

  float4 reflectDir;
  reflectDir.xyz = reflect(-viewDir, worldNormal);
  float perceptualRoughness = roughness; //(1.7 - 0.7 * roughness) * roughness;
  float mipmapLevel = perceptualRoughness * 4.0;
  reflectDir.w = mipmapLevel;

  float4 iblColor = skybox.SampleLevel(skybox_Sampler, reflectDir.xyz, reflectDir.w);
  iblColor.xyz = iblColor.xyz * iblColor.w * 4.0;
  
  float f0Inv = min(Fresnel * 2.0, 1.0) - Fresnel;
  float powNV = pow((1.0 - nv), 4.0);
  float SF = f0Inv * powNV + Fresnel;

  //vec3 envLight = iblColor.xyz * 0.5 * SF * CusAmbient.xyz;
  float3 envLight = iblColor.xyz * 0.5 * SF * AMBIENT_COLOR.xyz;
  
  // D
  float modifyRoughness = max(roughness * roughness, 0.1);
  float NdotH = nh1;
  float a2 = modifyRoughness * modifyRoughness;
  float d = (NdotH * a2 - NdotH) * NdotH + 1.0f; // 2 mad
  d = 0.31830988618f * a2 / (d * d + 1e-7f);
  d = min(d, 100.0);
  
  float rim = 1 - max(0, dot(viewDir, worldNormal)); 
  float3 rimColor = RimColor.xyz * pow(rim, 1 / RimPower);

  float fLerp = 1.0 - nv;
	float fV = lerp(Fresnel, 1.0, fLerp);
  float3 outspecular = (d*fV * LIGHT_COLOR + envLight) * SpecularColor.xyz;
  float3 finalCol = outspecular + outDiffuse + rimColor;

  outColor = float4(finalCol.x, finalCol.y, finalCol.z, 1.0f);
}
ENDCG

#END 

#DEFPASS ForwardAdd
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
  ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
  SHADOW_COORDS(4)
};

Texture2D MainTex;
Texture2D NormalTexture;
Texture2D SpecularTex;
Texture2D BRDFTex;
TextureCube skybox;
SamplerState MainTex_Sampler;
SamplerState NormalTexture_Sampler;
SamplerState SpecularTex_Sampler;
SamplerState BRDFTex_Sampler;
SamplerState skybox_Sampler;

float4 ShadeColor;
float4 ShadowColor;
float4 SpecularColor;

float Fresnel;
float extraShadeRange;


v2f vert(appdata v)
{
  COMPUTE_BONE_MATERIX(v);
  v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

  TRANSFER_SHADOW(o, v.vertex);
	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
    float2 in_Coordinate0 = i.uv;
    float4 in_NormalWS = i.worldnormal;
    float4 in_TangentWS = i.worldtangent;
    float4 in_BinormalWS = i.worldbinormal;

    float atten = SHADOW_ATTEN(i);

    float3 worldPos = float3(in_NormalWS.w, in_TangentWS.w, in_BinormalWS.w);
    float3 viewDir_S = CAMERA_WORLDPOSITION - worldPos.xyz;
    float3 viewDir = normalize(viewDir_S);

    float3 mainNormal = NormalTexture.Sample(NormalTexture_Sampler, in_Coordinate0.xy).xyz;
    float3 groundNormal = mainNormal.xyz * 2.0 - 1.0;

    float3 worldNormal = groundNormal.x * in_TangentWS.xyz + groundNormal.y * in_BinormalWS.xyz
					+ groundNormal.z * in_NormalWS.xyz;
    worldNormal = normalize(worldNormal);
     

    float3 light1Dir = -(LIGHT_GIVEN_DIRECTION);
    float3 h1 = normalize(viewDir + light1Dir);
    float nv = max(dot(worldNormal, viewDir), 0.0);
    float nh1 = max(dot(worldNormal, h1), 0.0);

    // main color
  float3 mainColor = MainTex.Sample(MainTex_Sampler, in_Coordinate0.xy).xyz;
	mainColor *= mainColor;

    float3 specular = SpecularTex.Sample(SpecularTex_Sampler, in_Coordinate0.xy).xyz;
	float roughness = 1.0 - specular.x;
	float curveness = specular.y;
	float shadowSelfMask = 1.0 - specular.z;

    // diffuse
  float3 diffuse = float3(0.0, 0.0, 0.0);
	float shaowRange = nv / extraShadeRange;
	float diffuseShadow = lerp(1.0, nv, shadowSelfMask);
	float nl1 = dot(worldNormal, light1Dir);
	float nl1Warp = (nl1 * 0.5) + 0.5;

	float2 brdfUV = float2(nl1Warp, curveness);
	float3 brdfColor = BRDFTex.Sample(BRDFTex_Sampler, brdfUV).xyz;
  
	float shadow = atten;
	float3 adjuseColor = lerp(ShadowColor.xyz, brdfColor.xyz, shadow);
	float3 fontLight = adjuseColor * LIGHT_COLOR * mainColor;

  	float nl2 = (dot(worldNormal, light1Dir) + 0.5) * 0.7;
	nl2 = max(nl2, 0.0);
	nl2 = nl2 * nl2;
	nl2 = nl2 * nl2;
	nl2 = nl2 * nl2;

	float3 backLight = nl2 * LIGHT_COLOR * mainColor;
	backLight = backLight * mainNormal.z;
	backLight = backLight / (float3(1.0, 1.0, 1.0) + backLight);

  float3 ambientLight =  AMBIENT_COLOR.xyz * mainColor;
  float3 white = float3(1.0, 1.0, 1.0);
	float3 diffuseShadowColor = lerp(ShadeColor.xyz, white.xyz, diffuseShadow);
	float3 outDiffuse = (backLight) * diffuseShadowColor;

  float4 reflectDir;
  reflectDir.xyz = reflect(-viewDir, worldNormal);
  float perceptualRoughness = roughness; //(1.7 - 0.7 * roughness) * roughness;
  float mipmapLevel = perceptualRoughness * 4.0;
  reflectDir.w = mipmapLevel;

  float4 iblColor = skybox.SampleLevel(skybox_Sampler, reflectDir.xyz, reflectDir.w);
  iblColor.xyz = iblColor.xyz * iblColor.w * 4.0;
  
  float f0Inv = min(Fresnel * 2.0, 1.0) - Fresnel;
  float powNV = pow((1.0 - nv), 4.0);
  float SF = f0Inv * powNV + Fresnel;

  //vec3 envLight = iblColor.xyz * 0.5 * SF * CusAmbient.xyz;
  float3 envLight = iblColor.xyz * 0.5 * SF * AMBIENT_COLOR.xyz;
  
  // D
  float modifyRoughness = max(roughness * roughness, 0.1);
  float NdotH = nh1;
  float a2 = modifyRoughness * modifyRoughness;
  float d = (NdotH * a2 - NdotH) * NdotH + 1.0f; // 2 mad
  d = 0.31830988618f * a2 / (d * d + 1e-7f);
  d = min(d, 100.0);

  float fLerp = 1.0 - nv;
	float fV = lerp(Fresnel, 1.0, fLerp);
 
  float3 finalCol = outDiffuse;

  outColor = float4(finalCol.x, finalCol.y, finalCol.z, 1.0f);

  
}
ENDCG

#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
  #pragma multi_compile_skin
	#include "lightpbr.inc"   

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
    ANI_ATTRIBUTE
	};

	struct v2f
	{
		float4 vertex : SV_POSITION;
	};

	v2f vert(appdata v)
	{
    COMPUTE_BONE_MATERIX(v);
		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = UniformNDC(clipPos);
		return o;
	}

	void frag(in v2f i, out float4 mainColor : SV_Target0)
	{
		mainColor = float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END