
#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { "%_BlendState", "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { "%_CullMode", "%_DepthMask", DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#pragma multi_compile RIM_REFLECTION_ON RIM_REFLECTION_OFF
#pragma multi_compile REFRACTION_ON REFRACTION_OFF
#pragma multi_compile ALPHAPREMULTIPLY_ON ALPHAPREMULTIPLY_OFF
#pragma multi_compile ALPHATEST_ON ALPHATEST_OFF

#include "lightpbr.inc"

struct appdata
{
    float4 vertex : POSITION;
    float3 normal : NORMAL;
    float3 binoraml : BINORMAL;
    float3 tangent : TANGENT;
    float2 uv : TEXCOORD0;
    ANI_ATTRIBUTE
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 worldnormal : TEXCOORD1;
    float4 worldtangent : TEXCOORD2;
    float4 worldbinormal : TEXCOORD3;
    float4 screenPos : TEXCOORD5;
    float4 vertex : SV_POSITION;
    SHADOW_COORDS(4)
};

Texture2D _MainTex;
Texture2D _MetallicGlossMap;
Texture2D _BumpMap;
Texture2D _EmissionMap;
Texture2D _RefractionTex;
SamplerState _MainSampler;
SamplerState _MetallicGlossMapSampler;
SamplerState _BumpMapSampler;
SamplerState _EmissionMapSampler;
SamplerState _RefractionSampler;
TextureCube _GlossEnvMap;
TextureCube _IrradianceMap;
SamplerState _GlossEnvMapSampler;
SamplerState _IrradianceMapSampler;
float _Smoothness;
float _Metallic;
float4 _EmissionColor;
float _Rotation;
float _CutOff;
float _Opacity;
float4 _RimColor;
float _RimPow;
float _RimIdentity;
Texture2D _SimpleReflectionTex;
SamplerState _SimpleReflectionSampler;
float _ReflectionIntensity;
float _RefractDistortion;
float _RefractAmount;
float _RefractRatio;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);

    v2f o;
    float4 pos = ObjectToClipPos(v.vertex);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
    o.screenPos = ComputeScreenPos(pos);
    o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
    o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
    o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

    o.worldnormal.w = worldpos.x;
    o.worldtangent.w = worldpos.y;
    o.worldbinormal.w = worldpos.z;

    TRANSFER_SHADOW(o, v.vertex);
    return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
// sample the texture
    float4 col = _MainTex.Sample(_MainSampler, i.uv);
    float2 mg = _MetallicGlossMap.Sample(_MetallicGlossMapSampler, i.uv).ra;
    float3 emissionMapColor = _EmissionMap.Sample(_EmissionMapSampler, i.uv).rgb;
    float3 normalTangent = _BumpMap.Sample(_BumpMapSampler, i.uv).rgb;
    normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
    float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldbinormal.xyz
+ normalTangent.z * i.worldnormal.xyz;
    normalWorld.xyz = normalize(normalWorld.xyz);

    float roughness = 1.0 - mg.g * _Smoothness;
    float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
    float3 dir = RotateAroundYInDegrees(normalWorld, _Rotation);
    float3 iblColor = SpecularIBLColor(_GlossEnvMap, _GlossEnvMapSampler, worldPos, normalWorld, roughness, _Rotation);
    float3 iblDiffuseColor = DiffuseIBLColor(_IrradianceMap, _IrradianceMapSampler, worldPos, dir);
    float3 reflectionColor = float3(0.0, 0.0, 0.0);
    float3 rim = float3(0.0, 0.0, 0.0);
    #if RIM_REFLECTION_ON
    float modulation = _MetallicGlossMap.Sample(_MetallicGlossMapSampler, i.uv).g;
    reflectionColor = SampleReflection(_SimpleReflectionTex, _SimpleReflectionSampler, modulation, _ReflectionIntensity, worldPos, normalWorld);
    rim = RimHeightLight(_RimColor.xyz, _RimIdentity, _RimPow, worldPos, normalWorld);
    #endif
    float3 refractColor = float3(0.0, 0.0, 0.0);
    #if REFRACTION_ON
        //refract
        float3 viewDir = normalize(worldPos - CAMERA_WORLDPOSITION.xyz);
        float refractRatio = 1.0/_RefractRatio;
        float3 refract_vec = refract(viewDir, normalWorld.xyz, refractRatio);
        float2 offset = refract_vec.xy * _RefractDistortion * CAMERA_RESOLUTION_INV.xy;
        i.screenPos.xy = offset + i.screenPos.xy/i.screenPos.w;
        i.screenPos.xy = float2(clamp(i.screenPos.x,0.0,1.0), clamp(i.screenPos.y,0.0,1.0));
        refractColor = _RefractionTex.Sample(_RefractionSampler, i.screenPos.xy).xyz * _RefractAmount;
    #endif

    SurfaceStandardInput input;
    input.albedo = col.rgb;
    input.metallic = mg.r * _Metallic;
    input.smoothness = mg.g * _Smoothness;
    input.worldNormal = normalWorld; // normalWorld;
    input.worldPos = worldPos;
    input.emission = AmbientColor() + _EmissionColor.rgb * emissionMapColor + reflectionColor + refractColor + rim;// * emissionMask;
    input.specularIbl = iblColor.rgb;
    input.diffuseIbl = iblDiffuseColor.rgb;
    input.alpha = col.a;
    input.atten = SHADOW_ATTEN(i);

    outColor.xyz = PBR_LightCalc(input);
    #if ALPHATEST_ON
        outColor.w = 1.0;
        if (col.a - _CutOff <= 0) {discard; }
    #else
        #if ALPHAPREMULTIPLY_ON
            outColor.w = input.alpha *  _Opacity;
        #else
            outColor.w = 1.0;
        #endif
    #endif
}
ENDCG

#END

#DEFPASS ForwardAdd
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", ONE, ONE, ONE }
DRAW_MODE = { "%_CullMode", DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#pragma multi_compile ALPHATEST_ON ALPHATEST_OFF
#pragma multi_compile ALPHAPREMULTIPLY_ON ALPHAPREMULTIPLY_OFF

#include "lightpbr.inc"

struct appdata
{
    float4 vertex : POSITION;
    float3 normal : NORMAL;
    float3 binoraml : BINORMAL;
    float3 tangent : TANGENT;
    float2 uv : TEXCOORD0;
    ANI_ATTRIBUTE
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 worldnormal : TEXCOORD1;
    float4 worldtangent : TEXCOORD2;
    float4 worldbinormal : TEXCOORD3;
    float4 vertex : SV_POSITION;
    SHADOW_COORDS(4)
};

Texture2D _MainTex;
Texture2D _MetallicGlossMap;
Texture2D _BumpMap;
SamplerState _MainSampler;
SamplerState _MetallicGlossMapSampler;
SamplerState _BumpMapSampler;
float _Smoothness;
float _Metallic;
float4 _EmissionColor;
float _CutOff;
float _Opacity;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);

    v2f o;
    float4 pos = ObjectToClipPos(v.vertex);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
    o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
    o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
    o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

    o.worldnormal.w = worldpos.x;
    o.worldtangent.w = worldpos.y;
    o.worldbinormal.w = worldpos.z;

    TRANSFER_SHADOW(o, v.vertex);
    return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
// sample the texture
    float4 col = _MainTex.Sample(_MainSampler, i.uv);
    float2 mg = _MetallicGlossMap.Sample(_MetallicGlossMapSampler, i.uv).ra;
    float3 normalTangent = _BumpMap.Sample(_BumpMapSampler, i.uv).rgb;
    normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
    float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldbinormal.xyz
+ normalTangent.z * i.worldnormal.xyz;
    normalWorld.xyz = normalize(normalWorld.xyz);

    SurfaceStandardInput input;
    input.albedo = col.rgb;
    input.metallic = mg.r * _Metallic;
    input.smoothness = mg.g * _Smoothness;
    input.worldNormal = normalWorld; // normalWorld;
    input.worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
    input.emission = float3(0.0, 0.0, 0.0);
    input.atten = SHADOW_ATTEN(i);
    input.alpha = col.a;
    input.specularIbl = float3(0.0, 0.0, 0.0);
    input.diffuseIbl = float3(0.0, 0.0, 0.0);

	outColor.xyz = PBR_LightCalc(input);
	outColor.w = 1.0;
	#if ALPHATEST_ON
		outColor.w = 1.0;
		if (col.a - _CutOff <= 0) {discard; }
	#else
		#if ALPHAPREMULTIPLY_ON
			outColor.w = input.alpha *  _Opacity;
		#else
			outColor.w = 1.0;
		#endif
	#endif
}
ENDCG

#END

#DEFPARAMS
_MainTex = { "Main Color", TEXTURE2D, "white" },
_MetallicGlossMap = {"Metallic Gloss", TEXTURE2D, "white"},
_BumpMap = {"Normal Map", TEXTURE2D, "bump"},
_GlossEnvMap = {"Specular IBL Map", TEXTURECUBE, "black"},
_IrradianceMap = {"Diffuse IBL Map",TEXTURECUBE,"black"},
_Smoothness = {"Smoothness", FLOAT, "0.5" },
_Metallic = { "Metallic", FLOAT, "0.5" },
_EmissionColor = {"Emission Color", COLOR, "0.0,0.0,0.0,1.0"},
_EmissionIntensity = {"Emission Intensity", FLOAT, "1.0"},
_EmissionMap = {"Emission Map",TEXTURE2D,"white"},
_Rotation = { "Rotation", FLOATRANGE, "0, 360, 0" },
_Opacity = { "Opacity", FLOAT, "1.0" },
_RimColor = {"Rim Color", COLOR, "1.0, 1.0, 1.0, 1.0"},
_RimPow = { "RimPow", FLOATRANGE, "2.0, 10.0, 0.0" },
_RimIdentity = { "RimIdentity", FLOATRANGE, "3.0, 10.0, 0.0" },
_SimpleReflectionTex = {"Simple Reflection",TEXTURE2D,"white"},
_ReflectionIntensity = {"ReflectionIntensity",FLOAT,"0.0"},
_CutOff = { "CutOff", FLOAT, "0.0" },
[Enum(RenderQueue)]
_RenderQueue = {"Render Queue", FLOAT, "1000"},
[Enum(BlendOnOff)]
_BlendState = {"Blend State", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
[Enum(DepthMode)]
_DepthMask = {"Depth Mask", FLOAT, "1.0"},
[Enum(CullMode)]
_CullMode = {"Cull Mode", FLOAT, "0.0"},
[Keywords(RIM_REFLECTION_ON, RIM_REFLECTION_OFF)]
_RimAndReflectionlState = {"RimAndReflection State", FLOAT, "1.0"},
[Keywords(ALPHAPREMULTIPLY_ON, ALPHAPREMULTIPLY_OFF)]
_AlphaPreMultiply = {"Alpha Pre Multiply", FLOAT, "1.0"},
[Keywords(ALPHATEST_ON, ALPHATEST_OFF)]
_ALPHATEST_ON = {"Alpha Test On", FLOAT, "1.0"},
[Keywords(REFRACTION_ON, REFRACTION_OFF)]
_RefractionState = {"Refraction State", FLOAT, "1.0"},
_RefractionTex = {"Refraction Color",TEXTURE2D,"white"},
_RefractAmount = { "RefractAmount", FLOATRANGE, "0.0, 1.0, 0.0" },
_RefractDistortion = { "RefractDistortion", FLOATRANGE, "0.0, 50.0, -50.0" },
_RefractRatio  = { "RefractRatio", FLOATRANGE, "0.0, 3.0, 0.0" },
#END

#DEFTAG
ShaderName = "StandardPbrGBuffer"
RenderQueue = "%_RenderQueue"
#END

#DEFPASS GBuffer
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_ON, -1,  
STENCIL_FUNCTION_ALWAYS, 1, -1, STENCIL_OPERATION_KEEP, STENCIL_OPERATION_KEEP, STENCIL_OPERATION_REPLACE,
STENCIL_FUNCTION_ALWAYS, 1, -1, STENCIL_OPERATION_KEEP, STENCIL_OPERATION_KEEP, STENCIL_OPERATION_REPLACE}
LIGHT_MODE = { GBUFFER }




CGPROGRAM

#define USE_GLES_FBF_DEFERRED (VENUS_MRT_FRAMEBUFFER_FETCH && (SHADER_API_GLES || SHADER_API_GLES3))
#define USE_PLS_DEFERRED (VENUS_MRT_PLS && (SHADER_API_GLES || SHADER_API_GLES3))

#pragma vertex vert
#pragma fragment frag
#pragma multi_compile REFRACTION_ON REFRACTION_OFF
#pragma multi_compile RIM_REFLECTION_ON RIM_REFLECTION_OFF
#pragma multi_compile_mrt_fbfetch
#include "lightpbr.inc"
#include "lightdeferred.inc"

struct appdata
{
    float4 vertex : POSITION;
    float3 normal : NORMAL;
    float3 binoraml : BINORMAL;
    float3 tangent : TANGENT;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 worldnormal : TEXCOORD1;
    float4 worldtangent : TEXCOORD2;
    float4 worldbinormal : TEXCOORD3;
    float4 screenPos : TEXCOORD5;
    float4 vertex : SV_POSITION;
};


Texture2D _MainTex;
Texture2D _MetallicGlossMap;
Texture2D _BumpMap;
Texture2D _EmissionMap;
Texture2D _RefractionTex;
Texture2D TEXTURE_GBUFFER_A;
Texture2D TEXTURE_GBUFFER_B;
Texture2D TEXTURE_GBUFFER_C;


SamplerState _MainSampler;
SamplerState _MetallicGlossMapSampler;
SamplerState _BumpMapSampler;
SamplerState _EmissionMapSampler;
SamplerState _RefractionSampler;
TextureCube _GlossEnvMap;
TextureCube _IrradianceMap;
SamplerState _GlossEnvMapSampler;
SamplerState _IrradianceMapSampler;
SamplerState TEXTURE_GBUFFER_A_SAMPLER;
SamplerState TEXTURE_GBUFFER_B_SAMPLER;
SamplerState TEXTURE_GBUFFER_C_SAMPLER;

float _Smoothness;
float _Metallic;
float4 _EmissionColor;
float _EmissionIntensity;
float _Rotation;
float _CutOff;
float _Opacity;
float4 _RimColor;
float _RimPow;
float _RimIdentity;
Texture2D _SimpleReflectionTex;
SamplerState _SimpleReflectionSampler;
float _ReflectionIntensity;
float _RefractDistortion;
float _RefractAmount;
float _RefractRatio;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);

    v2f o;
    float4 pos = ObjectToClipPos(v.vertex);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
    o.screenPos = ComputeScreenPos(pos);
    o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
    o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
    o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

    o.worldnormal.w = worldpos.x;
    o.worldtangent.w = worldpos.y;
    o.worldbinormal.w = worldpos.z;

    return o;
}

void frag(
  in v2f i
#if !(USE_PLS_DEFERRED || USE_GLES_FBF_DEFERRED)
, out float4 GBufferA : SV_Target0
, out float4 GBufferB : SV_Target1
, out float4 GBufferC : SV_Target2
, out float  GBufferD : SV_Target3
#endif
)
{
   
    float3 normalTangent = _BumpMap.Sample(_BumpMapSampler, i.uv).rgb;
    normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
    float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldbinormal.xyz
    + normalTangent.z * i.worldnormal.xyz;
    normalWorld.xyz = normalize(normalWorld.xyz);
    float3 emissionMapColor = _EmissionMap.Sample(_EmissionMapSampler, i.uv).rgb;
    
	float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	float melta = _MetallicGlossMap.Sample(_MetallicGlossMapSampler, i.uv).r;
	float4 color = _MainTex.Sample(_MainSampler, i.uv);
    float3 col = color.rgb;
    float alpha = color.a;
    float smoothness = _MetallicGlossMap.Sample(_MetallicGlossMapSampler, i.uv).a;
    smoothness = smoothness * _Smoothness;
	float metallic = _Metallic * melta;

    float3 dir = RotateAroundYInDegrees(normalWorld, _Rotation);
    float roughness = 1.0 - smoothness;
    float3 iblColor = SpecularIBLColor(_GlossEnvMap, _GlossEnvMapSampler, worldPos, normalWorld, roughness, _Rotation);
    float3 iblDiffuseColor = DiffuseIBLColor(_IrradianceMap, _IrradianceMapSampler, worldPos, dir);
    float3 reflectionColor = float3(0.0, 0.0, 0.0);
    float3 rim = float3(0.0, 0.0, 0.0);
    #if RIM_REFLECTION_ON
    float modulation = _MetallicGlossMap.Sample(_MetallicGlossMapSampler, i.uv).g;
    reflectionColor = SampleReflection(_SimpleReflectionTex, _SimpleReflectionSampler, modulation, _ReflectionIntensity, worldPos, normalWorld);
    rim = RimHeightLight(_RimColor.xyz, _RimIdentity, _RimPow, worldPos, normalWorld);
    #endif
    float3 refractColor = float3(0.0, 0.0, 0.0);
    #if REFRACTION_ON
        //refract
        float3 viewDir = normalize(worldPos - CAMERA_WORLDPOSITION.xyz);
        float refractRatio = 1.0/_RefractRatio;
        float3 refract_vec = refract(viewDir, normalWorld.xyz, refractRatio);
        float2 offset = refract_vec.xy * _RefractDistortion * CAMERA_RESOLUTION_INV.xy;
        i.screenPos.xy = offset + i.screenPos.xy/i.screenPos.w;
        i.screenPos.xy = float2(clamp(i.screenPos.x,0.0,1.0), clamp(i.screenPos.y,0.0,1.0));
        refractColor = _RefractionTex.Sample(_RefractionSampler, i.screenPos.xy).xyz * _RefractAmount;
    #endif

    float3 emissionColor = AmbientColor() + _EmissionColor.rgb * emissionMapColor * _EmissionIntensity + reflectionColor + refractColor + rim;// * emissionMask;

    half3 specColor = half3(0.0, 0.0, 0.0);
	half oneMinusReflectivity = 0.0;
	half3 albedo = DiffuseAndSpecularFromMetallic(col, metallic, specColor, oneMinusReflectivity);
	float alpha_temp = 0.0;
	albedo = PreMultiplyAlpha(albedo,alpha,oneMinusReflectivity, alpha_temp);

    float3 iblDiffuseTerm = albedo * iblDiffuseColor;

    float perceptualRoughness = 1.0 - smoothness;
    roughness = perceptualRoughness * perceptualRoughness;
	roughness = max(roughness, 0.002);
	half surfaceReduction = 0.0;
#if GammaSpace
	surfaceReduction = 1.0-0.28*roughness*perceptualRoughness;
#else
	surfaceReduction = 1.0 / (roughness * roughness + 1.0);
#endif
    half grazingTerm = saturate(smoothness + (1-oneMinusReflectivity));
    float3 V = WorldViewDir(worldPos);
    float dotNV =  saturate(dot(normalWorld, V));
    float3 specularEnv = surfaceReduction * FresnelLerp (specColor, grazingTerm.xxx, dotNV);
    float3 iblSpecularTerm = specularEnv * iblColor;

    float3 basePassTerm =  emissionColor + iblDiffuseTerm + iblSpecularTerm;

    GBufferData data;
	data.base_color = col;
    data.alpha = alpha;
	data.world_normal = normalWorld;
	data.smoothness = smoothness;
	data.basepass_color = basePassTerm;
	data.metalness = metallic;

    float4 result[3];

    EncodeGBuffer(data,result);


#if USE_PLS_DEFERRED

    GLFramebufferFetchWrite0(result[0]);
    GLFramebufferFetchWrite1(result[1]);
    GLFramebufferFetchWrite2(result[2]);
    //GLFramebufferFetchDepthWrite(i.vertex.z);
#elif USE_GLES_FBF_DEFERRED
    GLFramebufferFetchWrite0(result[0]);
    GLFramebufferFetchWrite1(result[1]);
    GLFramebufferFetchWrite2(result[2]);

#if USE_SCENE_DEPTH_ON
    //GLFramebufferFetchDepthWrite(i.vertex.z);
#else

    GLFramebufferFetchWrite3(float4(i.vertex.z, 0, 0, 0));
#endif //USE_SCENE_DEPTH_ON

#else
    GBufferA = result[0];
	GBufferB = result[1];
	GBufferC = result[2];
    GBufferD = i.vertex.z;
#endif
    
}
ENDCG

#END

#DEFPASS Depth
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { DEPTHPASS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "lightpbr.inc"
#pragma multi_compile_skin

struct appdata
{
    float4 vertex : POSITION;
    float3 normal : NORMAL;
    ANI_ATTRIBUTE
};

struct v2f
{
    float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);

    float4 clipPos = ObjectToClipPos(v.vertex);
    clipPos = ApplyShadowBias(clipPos);

    v2f o;
    o.vertex = UniformNDC(clipPos);
    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    mainColor = float4(0.0, 0.0, 0.0, 1.0);
}
ENDCG
#END
