

#DEFPARAMS
TEXELSIZE = { "TexelSize", VEC2, "0.0,0.0" },
BLOOM_THRESHOLD = { "BloomThreshold", FLOAT, "0.0" },
SOFT_THRESHOLD = { "SoftThreshold", FLOAT, "0.5" },
#END

#DEFTAG
ShaderName = "LightPrefilter"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 TEXELSIZE;
float BLOOM_THRESHOLD;
float SOFT_THRESHOLD;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float3 mainColor : SV_Target0)
{
  float delta = 1.0f;
  float4 o = TEXELSIZE.xyxy * float2(-delta, delta).xxyy;
  float2 aroundCoord[4];

  // down sampling
  aroundCoord[0] = i.uv + o.xy;
  aroundCoord[1] = i.uv + o.zy;
  aroundCoord[2] = i.uv + o.xw;
  aroundCoord[3] = i.uv + o.zw;
  mainColor  = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[0] ).xyz;
  mainColor += TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[1] ).xyz;
  mainColor += TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[2] ).xyz;
  mainColor += TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[3] ).xyz;
  mainColor = mainColor * 0.25;

  // light prefilter
  float alpha = dot(mainColor.xyz, float3(0.29899999, 0.58700001, 0.114));
  float knee = BLOOM_THRESHOLD * SOFT_THRESHOLD;
  float soft = alpha - BLOOM_THRESHOLD + knee;
  soft = clamp(soft, 0, 2*knee);
  soft = soft * soft / (4 * knee + 0.00001);
  float contribution = max(soft, alpha - BLOOM_THRESHOLD);
  contribution /= max(alpha, 0.00001);
  mainColor.xyz *= contribution;
}
ENDCG
#END
