--require "venusdebug"
local detectdefined = require "facecute.transitions.transitiondefine"
local FiniteStateMachine = require "facecute.transitions.FiniteStateMachine"
local Object = require "classic"

local transition = Object:extend();

function transition:new(ht,immortal)
    self.isshow = false
    self.preframe_actionid = {};
    self.curframe_actionid = {};
    self.fsm = nil;
    self.MySTT = {};
    self.ht = ht--本状态机管理的人头资源
    self.immortal = immortal --本状态机管理的常驻资源
    self.activeAny = false --是否触发了初始化动作
    self.activeHt = false --是否触发了人脸出现动作
    self.activeForeground = false --是否触发的背景出现动作
    self.activeBackground = false --是否触发的背景出现动作
    self.triggerList = detectdefined.triggerList --actionid对应的动作
end

function transition:ParseConfig(config)

    local jTransitions = config["transitions"];
    self.MySTT = {}
    
    --储存逻辑到MySTT
    for jTransName, jTrans in pairs(jTransitions) do
        if next(jTrans["conditions"]) ~= nil and next(jTrans["targets"]) ~= nil then
            for _, jCond in pairs(jTrans["conditions"]) do

                --当v["preState"]中状态为invisible时，设置为""
                if jCond["preState"] ~= nil and string.find(jCond["preState"], "invisible") ~= nil then
                    jCond["preState"] = ""
                end

                for _, jTarget in pairs(jTrans["targets"]) do
                    local preState = {}
                    local event
                    local newState = {}
                    local action = {}
                    local randomShow

                    if jCond["preState"] ~= nil and jCond["preState"] ~= "" then
                        table.insert(preState, jCond["preState"])
                    end

                    if jCond["triggers"] ~= nil then
                        event = jCond["triggers"]
                    end

                    newState[jTarget.targetPart] = jTarget.targetState;

                    action = jTrans["targets"];

                    randomShow = jTrans["randomShow"];

                    table.insert(self.MySTT, {preState,event,newState,action,randomShow});
                end
            end
        end
    end
    --根据储存的statetransitiontable创建对应的有限状态机
    self.fsm = FiniteStateMachine(self.MySTT);

    self.activeAny = false
    self.activeHt = false
    self.activeForeground = false
    self.activeBackground = false
end



--设置是否显示
--更新贴纸的状态
function transition:SetShow(isshow)

    if self.isshow ~= isshow then
        self.isshow = isshow

        if isshow == true then --当人头出现的时候
            self.activeHt = false
            self.activeAny = false
        else --当人头消失的时候
            --将贴纸暂停
            for k,v in pairs(self.fsm.cur_state) do
                --只负责头部贴纸，不管公共贴纸
                local obj = self.ht:getAsset(k)
                if obj ~= nil then 
                    obj:PauseInFirstFrame()--先将贴纸设置到第一帧
                    obj:Hide()--之后隐藏贴纸
                end 
            end
        end
    end
end

--将当前帧中所有动作的disappear设置为true
function transition:InitFrameActionid()
    self.curframe_actionid = {}
    for i = 1,20 do 
        self.curframe_actionid[2^i + 1] = true
    end
end

--根据当前transition中的各个项改变贴纸的状态
function transition:UpdateEffectFromFSM()
    --根据当前transition中的各个项改变贴纸的状态
    LOG("SUNTYLOG: transition:UpdateEffectFromFSM " .. TableKeysToStr(self.fsm.target_list))
    if next(self.fsm.target_list) ~= nil then 
        for _,v in pairs(self.fsm.target_list) do
            LOG("SUNTYLOG: transition:UpdateEffectFromFSM getting "..v.targetPart)
            --得到当前的资源
            local obj = self.ht:getAsset(v.targetPart)
            if obj == nil then
                obj = self.immortal:getAsset(v.targetPart)
            end
            --触发当前资源的状态
            if obj ~= nil then
                local eventArgs = {
                    delay = v.delay == 0 and nil or v.delay,
                    lasting = v.lastingFrame == 0 and nil or v.lastingFrame,
                    fading = v.fadingFrame == 0 and nil or v.fadingFrame,
                    loop = v.loop
                }
                obj:Trigger(v.targetState, eventArgs)

                --if v.targetState == "first_frame" then
                --    obj:PauseInFirstFrame()
                --elseif v.targetState == "playing" then
                --    obj:Play(v.delay,v.loop,v.lastingFrame,v.fadingFrame,true)
                --elseif v.targetState == "paused" then
                --    obj:Pause()
                --elseif v.targetState == "last_frame" then
                --    obj:PauseInLastFrame()
                --elseif v.targetState == "invisible" then
                --    obj:Hide()
                --end
            else
                LOG("SUNTYLOG: transition:UpdateEffectFromFSM not found "..v.targetPart)
            end
        end
        self.fsm.target_list = {}
    end 
end

function transition:Update(action,index)

    if self.fsm == nil then
        return
    end

    -- 触发初始化，无动作时候触发
    if self.activeAny == false and self.fsm.event_list["*"]~=nil then 
        local result = self.fsm:fire("*") 
        self.activeAny = true
        if result ~= "." then
            print("transition id: ",index,"------------------------------")
            print("Event:"..result.." .*")
            self.fsm:get()
            self:UpdateEffectFromFSM()
            print("-----------------------------------------------------\n")

            LOG("SUNTYLOG: transition id: "..tostring(index).."------------")
            LOG("SUNTYLOG: Event:"..result.." .*")
            LOG("SUNTYLOG: ------------------------------------------------")
            return
        end
    end 

    -- 触发背景出现  H.background.appear
    if self.activeBackground == false and self.fsm.event_list["H.background.appear"]~=nil then 
        local result = self.fsm:fire("H.background.appear") 
        self.activeBackground = true
        if result ~= "." then
            print("transition id: ",index,"------------------------------")
            print("Event: "..result..".H.background.appear")
            self.fsm:get()
            self:UpdateEffectFromFSM()
            print("-----------------------------------------------------\n")

            LOG("SUNTYLOG: transition id: "..tostring(index).."------------")
            LOG("SUNTYLOG: Event:"..result.." .H.background.appear")
            LOG("SUNTYLOG: ------------------------------------------------")
            return
        end
    end 

    -- 触发前景出现  H.front.appear
    if self.activeForeground == false and self.fsm.event_list["H.front.appear"]~=nil then
        local result = self.fsm:fire("H.front.appear")
        self.activeForeground = true
        if result ~= "." then
            print("transition id: ",index,"------------------------------")
            print("Event:"..result.." .H.front.appear")
            self.fsm:get()
            self:UpdateEffectFromFSM()
            print("-----------------------------------------------------\n")

            LOG("SUNTYLOG: transition id: "..tostring(index).."------------")
            LOG("SUNTYLOG: Event:"..result.." .H.front.appear")
            LOG("SUNTYLOG: ------------------------------------------------")
            return
        end
    end

    -- 根据当前transition中是否有ht，触发人脸出现的事件 H.face.appear
    if self.activeHt == false and self.ht ~= nil and self.fsm.event_list["H.face.appear"]~=nil then 
        local result = self.fsm:fire("H.face.appear")
        if result == "*" then --若人脸触发的前提条件为空，则将当前状态设置为空，再次触发
            self.fsm.cur_state={} 
            result = self.fsm:fire("H.face.appear")
        end
        self.activeHt = true
        if result ~= "." then
            print("transition id: ",index,"------------------------------")
            print("Event:"..result..".H.face.appear ")
            self.fsm:get()
            self:UpdateEffectFromFSM()
            print("-----------------------------------------------------\n")

            LOG("SUNTYLOG: transition id: "..tostring(index).."------------")
            LOG("SUNTYLOG: Event:"..result.." .H.face.appear")
            LOG("SUNTYLOG: ------------------------------------------------")
            return
        end
    end

    --储存得到当前帧的动作数据：
    self:InitFrameActionid()
    if(action and action[1]) then
        for i = 1,#action do
            self.curframe_actionid[action[i].actionid] = true
            self.curframe_actionid[action[i].actionid + 1] = nil
        end
    end
    
    for k,v in pairs(self.curframe_actionid) do
        if self.preframe_actionid[k]==nil then--当前动作在前一帧中没有出现过，触发此动作
            if self.fsm.event_list[self.triggerList[k]]~=nil then
                local result = self.fsm:fire(self.triggerList[k])
                if result ~= "." then
                    print("transition id: ",index,"------------------------------")
                    print("Event:   "..result.."."..self.triggerList[k])
                    self.fsm:get()
                    self:UpdateEffectFromFSM()
                    print("-----------------------------------------------------\n")

                    LOG("SUNTYLOG: transition id: "..tostring(index).."------------")
                    LOG("SUNTYLOG: Event:"..result.." ."..self.triggerList[k])
                    LOG("SUNTYLOG: ------------------------------------------------")

                    --将当前帧识别的动作curframe_actionid赋值到preframe_actionid中，与下一帧识别的动作对比
                    self.preframe_actionid = {}
                    for k2,v2 in pairs(self.curframe_actionid) do 
                        self.preframe_actionid[k2] = v2
                    end

                    --此处若返回会导致丢失事件，和商汤行为不符
                    --return
                end
            end
        end
    end


--[[
    if(action and action[1]) then--判断当前动作是否在前一帧中的动作中出现过，若没有出现过，就触发此动作
        for i = 1,#action do
            if self.preframe_actionid[action[i].actionid]==nil then--当前动作在前一帧中没有出现过，触发此动作
                if self.fsm.event_list[self.triggerList[action[i].actionid] ]~=nil then
                    local result = self.fsm:fire(self.triggerList[action[i].actionid])
                    if result ~= "." then
                        print("transition id: ",index,"------------------------------")
                        print("Event:   "..result.."."..self.triggerList[action[i].actionid])
                        self.fsm:get()
                        self:UpdateEffectFromFSM()
                        print("-----------------------------------------------------\n")
                        
                        --将当前帧识别的动作curframe_actionid赋值到preframe_actionid中，与下一帧识别的动作对比
                        self.preframe_actionid = {}
                        for k2,v2 in pairs(self.curframe_actionid) do 
                            self.preframe_actionid[k2] = v2
                        end

                        return
                    end
                end
            end
        end
    end
]]--

    --将当前帧识别的动作curframe_actionid赋值到preframe_actionid中，与下一帧识别的动作对比
    self.preframe_actionid = {}
    for k2,v2 in pairs(self.curframe_actionid) do 
        self.preframe_actionid[k2] = v2
    end
    
    --更新贴纸的状态
    --贴纸状态obj.state有：first_frame playing paused last_frame invisible
    local fsm_cur_state = {}
    for part, state in pairs(self.fsm.cur_state) do
        local obj = self.ht:getAsset(part)
        if obj == nil then obj = self.immortal:getAsset(part) end
        local trigger = (obj ~= nil) and obj:TestTrigger() or nil
        if obj ~= nil and trigger ~= nil then
            fsm_cur_state[part] = trigger
        end
    end

    --得到贴纸的当前状态，触发Sticker Event
    --Sticker Event的Trigger有：begin play pause end hide
    for part, state in pairs(fsm_cur_state) do
        local obj = self.ht:getAsset(part)
        if obj== nil then obj = self.immortal:getAsset(part) end

        local targetState = state
        local trigger = detectdefined.TargetStateList[targetState]
        local event = "A." .. part .. "." .. trigger
        
        if obj ~= nil and self.fsm.event_list[event] ~= nil then
            
            local result = self.fsm:fire(event)
            if result ~= "." then
                print("transition id: ",index,"------------------------------")
                print("Event    " .. event)
                if result ~= "*" then self.fsm:get() end
                self.fsm:get()
                self:UpdateEffectFromFSM()
                self.fsm.cur_state[part] = targetState
                if (targetState == "invisible") then
                    self.fsm.cur_state[part] = nil
                end
                print("-----------------------------------------------------\n")

                LOG("SUNTYLOG: transition id: "..tostring(index).."------------")
                LOG("SUNTYLOG: Event    " .. event)
                LOG("SUNTYLOG: ------------------------------------------------")

                --此处若返回会导致丢失事件，和商汤行为不符
                --return
            end
        end
    end

    

end




return transition;
