local FaceMophBase = require "biugo.morph_base"
local biugodefined = require "biugo.defined"
local Object = require "classic"



local FaceMorph = FaceMophBase:extend();


function FaceMorph:new(morphInfo,fboSize)
  FaceMorph.super.new(self,morphInfo,fboSize);
  
  --windows 版本自己调用下DoMorph
  --self:DoMorph();
end

function FaceMorph:DoMorph()
  
  self.texlist = {};
  local landmarklist = {};
  local texStreamlist = {};
  
  local templates = biugodefined.FaceMorphTemplate;
  for i, template in ipairs(templates) do
    self.texlist[i], landmarklist[i]  = self:LoadTemplate(template);  
    texStreamlist[i] = self.texlist[i]:GetSourceStream();
  end
  
  local indiceslist = {1, 2, 1, 2, 1};
  local showtimelist = {2, 2, 2};
  local transtimelist = {10, 10, 10};
  
  FaceMorph.super.SetMorphTextureInfos(self, texStreamlist, landmarklist);
  FaceMorph.super.DoMorph(self, indiceslist, showtimelist, transtimelist);
end




return FaceMorph;