
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local ContentManager = require "apolloengine.content.contentmanager"
local BakeAnimation = venuscore.VenusBehavior:extend("BakeAnimation");

function BakeAnimation:new()
    --self.savePath = "D:/code/algo_video_facecute/assets/cjj_record_anim/config/animations.txt";
    self.savePath = "";
    self.isBaking = false;
    self.tryPushButton = false;
    self.PushedButton = self.tryPushButton;
end

function BakeAnimation:_OnAwake()
end

function BakeAnimation:_OnStart()
end

function BakeAnimation:_OnUpdate()
    if self.tryPushButton ~= self.PushedButton then
        self:StartBaking();
        self.isBaking = true;
        self.tryPushButton = self.PushedButton;
        ERROR("CJJLOG: StartBaking..")
    end
    if self.isBaking and self:IsPlayFinish() == true then
        self:EndBaking();
        self.isBaking = false;
        ERROR("CJJLOG: EndBaking..")
    end
end

function BakeAnimation:StartBaking()
    if self.AnimationCom and self.SkinCom and self.savePath then
        self.AnimationCom:Reset();
        self.AnimationCom:Play();
        self.SkinCom:StartBaking(self.savePath);
    end
end

function BakeAnimation:IsPlayFinish()
    if self.AnimationCom then
        local animName = self.AnimationCom:GetCurrentAnimationName();
        if animName and animName~="" then
            return self.AnimationCom:IsFinish(animName);
        end
    end
    return false;
end

function BakeAnimation:EndBaking()
    if self.SkinCom and self.savePath then
        self.SkinCom:EndBaking(self.savePath);
    end
end

function BakeAnimation:GetApplynnn()
    return self.tryPushButton;
end

function BakeAnimation:SetApplynnn(f)
    self.tryPushButton = f;
end
--[[
BakeAnimation:MemberRegister(
    "savePath",
    venuscore.ScriptTypes.FilePathType(
        {"json"},
        nil,
        function(thiz, value)
            thiz.path = value;
        end
    )
);
]]

BakeAnimation:MemberRegister(
  "AnimationCom",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.AnimationComponent:RTTI()
  )
);

BakeAnimation:MemberRegister(
  "SkinCom",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.SkinComponent:RTTI()
  )
);

BakeAnimation:MemberRegister("savePath");

BakeAnimation:MemberRegister("bake",
  venuscore.ScriptTypes.ImageButtonType(
  {
    textName = "bake",
    icon = "comm:documents/icons/particular.png",
    size = {30,30},
    tip = "bake",
    sameline = false,
  },
  BakeAnimation.GetApplynnn,
  BakeAnimation.SetApplynnn
));

return BakeAnimation;