local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"

local SavePngBehavior = venuscore.VenusBehavior:extend("SavePngBehavior"); 
local configSavePath = "proj:"
function SavePngBehavior:new()
  self.captureCamera = nil;  
  self._captureCameraUpdateCnt = 0;
  self.PngPreName = "pic";
  self.SavePngPath = "D:\\Png\\";
  self.On_Off = false;
  
 
end

function SavePngBehavior:_Initialize()
 
end


function SavePngBehavior:_OnAwake()
  self:_Initialize();
end


function SavePngBehavior:_OnStart()
  
end


function SavePngBehavior:_OnUpdate(def)
  self:_CaptureProcess();
end


function SavePngBehavior:_CaptureProcess()
  if self.On_Off == false then
    return;
  end
  --处理截帧的相机
  if self.captureCamera then
    if self.captureCamera.Active == true then
      if self._captureCameraUpdateCnt > 0 then
        local captureCamComp = self.captureCamera:GetComponent(apolloengine.Node.CT_CAMERA);
        if captureCamComp then
          local cameranode = captureCamComp:GetHostNode();
          local captureRT = captureCamComp:GetAttachedRenderTarget();
          if captureRT then
            local stream = captureRT:GetAttachmentStream(apolloengine.RenderTargetEntity.TA_COLOR_0);
            if stream then

              local pngName = self.PngPreName.."_"..self._captureCameraUpdateCnt..".png";
              local fullpath =  self.SavePngPath..pngName;
              apolloengine.IGraphicSystem:SaveToPng(fullpath,stream);
              self._captureCameraUpdateCnt = self._captureCameraUpdateCnt + 1;
            end
          end
        else
          ERROR("Capture camera is not a valid camera node");
        end
      else
        self._captureCameraUpdateCnt = self._captureCameraUpdateCnt + 1;
      end
    end
  end
end


function SavePngBehavior:_OnPackage()
end

function SavePngBehavior:GetCaptureCamera()
  return self.captureCamera;
end

function SavePngBehavior:SetCaptureCamera(cameraRef)
  self.captureCamera = cameraRef;
  local captureCamComp = self.captureCamera:GetComponent(apolloengine.Node.CT_CAMERA);
  
  if captureCamComp then
    local CameraResolution = captureCamComp.CameraResolution;
  
    captureCamComp:SetClearColor(mathfunction.Color(0.0, 0.0,0.0, 0.0));
    local rt = apolloengine.RenderTargetEntity();--创建一个FBO
    local viewport = mathfunction.vector4(0.0,0.0,CameraResolution:x(),CameraResolution:y())
    rt:PushMetadata(--设置FBO格式
        apolloengine.RenderTargetMetadata(
          apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
          apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
          viewport,
          CameraResolution));--分辨率
    
    local tex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
    tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.TextureEntity.TU_READ,
        CameraResolution));
      
    rt:CreateResource();
    
    captureCamComp:AttachRenderTarget(rt);
  end
    
end

function SavePngBehavior:GetPngPreName()
  return self.pngPreName;
end

function SavePngBehavior:SetPngPreName(prename)
  self.pngPreName = prename;
end




 SavePngBehavior:MemberRegister("captureCamera",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI(),
    SavePngBehavior.GetCaptureCamera,
    SavePngBehavior.SetCaptureCamera
  )); 

SavePngBehavior:MemberRegister("PngPreName");
SavePngBehavior:MemberRegister("SavePngPath");
SavePngBehavior:MemberRegister("On_Off");






return SavePngBehavior;