local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local ncnn = require "ncnnfunction"
local videodecet = require "videodecet"
require "utility"
local apolloDefine = require "apolloutility.defined"



local poseestimates = {}



local std3d = {
  110.7224395224947,
  22.388176174254347,
  72.46294421720373,
  158.56311079063173,
  189.33832206725427,
  208.80479145798353,
  191.79935232131172,
  243.2006168338775,
  247.56193295984693,
  110.72180724487369,
  22.38805433286514,
  72.46252568188349,
  158.80454092789694,
  199.77187809476604,
  214.7062978421496,
  180.01944122294572,
  250.52739312762094,
  248.53247137512838,
  52.10694018270771,
  52.1140552562803,
  69.08241483855363,
  95.15366543888481,
  101.33031820020669,
  128.9973251543324,
  117.42457701224566,
  126.48468958404065,
  164.65090647971442,
  123.6029657528179,
  130.85538909944856,
  164.33336500814266,	
  146.02231892533874,
  97.0795598515937,
  139.52731252584186,
  243.47531766057696,
  129.82248593326003,
  202.30181232857467,
  244.6877004789904,
  215.01816411816674,
  239.3823472541272,
  138.760844460741,
  100.89260001133229,
  142.44109658418054,
  236.87528986742385,
  144.91219013036826,
  209.80829096235226,
  244.00694913404305,
  239.7502834976899,
  255.20583985806599,
}

local mean3d = {
  -0.2556525886947795,
  -7.119605727416116,
  -0.9814330584948388,
  -5.654630512911183,
  319.63600940520956,
  71.93292692469369,
  -10.170583994141206,
  691.147891657268,
  155.35298624455555,
  0.2556513148981795,
  7.119546036952688,
  0.9814238602344578,
  -5.097297795487889,
  327.0404131275415,
  72.22580948277306,
  -9.996566061820296,
  708.2773832914069,
  158.01640791345199,
  2.9058367556287306,
  -211.36330686630447,
  -47.421091522341754,
  5.6753780407515935,
  -435.08890570553115,
  -97.69740161233229,
  5.93884963674382,
  -491.891970054098,
  -110.66661784332683,
  7.373520833615209,
  -583.9486185314574,
  -131.17140035921526,
  5.4192065289241445,
  -383.9317019573139,
  -86.81454166710293,
  2.959646625166301,
  -187.56748832018525,
  -43.453693436849946,
  1.26585821672136,
  -120.17057902524314,
  -28.252604914874993,
  4.671866390210052,
  -383.64408934471885,
  -85.51257837102308,
  1.6764857129649644,
  -197.00717718979865,
  -43.136836346611325,
  0.8705690141490188,
  -168.66456902427169,
  -37.39024980077856,
  -37.39024980077856,
}

local testinput = {
      -3.6432094938436173,
			-2.473685800253388,
			-3.5018250001633247,
			-2.2819855269614098,
			-3.355808821405587,
			-3.110499007315905,
			-3.1291815048255645,
			-3.2168022790605875,
			-3.6045638264489357,
			-2.3677907588904206,
			-3.380459394626892,
			-3.3190215190019026,
			-3.1542806114933217,
			-3.347422362827337,
			-3.65964250277779,
			-1.6848070235977601,
			-3.6916704592574328,
			-1.643562328039885,
			-3.5677230346766726,
			-0.8651148678037828,
			-3.5789365409813554,
			-1.651235022129677,
			-3.2181442159842892,
			-1.980565873738015,
			-3.2090677781771455,
			-1.5089156655093818,
			-3.4225364948009607,
			-1.553532718935693,
			-3.4220176026832583,
			-1.6834460612684448,
			-3.2643694516504516,
			-1.1807339111180348
    }
    
local mean2d = {534.2362067815909,425.88147731177776,533.393731182906,425.6983578158579,534.3978023429365,497.43802989193154,532.481293821069
,569.0466234375722,535.2915655822208,425.73629461606714,532.7675617662295,496.4731547066457,530.8880341233735,569.6075068344198,535.7534460606558
,331.2267732306162,536.3380005282891,317.4499285783894,536.7162946417122,269.119694669409,536.3674026383682,330.27798906492825,535.8566970903066
,374.59944401417664,534.7028848175864,387.35266055116455,534.9920256553606,331.7734652688376,534.611308079746,373.81679138734876,535.2152919182024
,379.5077967523042}

local std2d = {107.37361012086936,61.634909589570334,114.89497052627252,61.911997024725586,117.27565510971122,50.22711629323473,118.89857526011964
,55.0000570865409,102.91089763326161,61.338520877316505,106.6694471505881,47.96084756161423,108.13481259325421,53.60647265856601
,110.5622742770474,72.91669969652871,110.84492972268202,76.09916642663414,115.08215260502243,82.92943734420392,105.04274863959776
,72.84070268738881,106.31581039747435,73.21929020828857,108.0876752788032,82.49487760274116,124.31763034139937,73.34214366385531,132.80917569040227
,76.37108859015507,131.60933137204532,88.82878858279597}

local bonepair = {
  {0,1},
  {1,2},
  {2,3},
  {0,4},
  {4,5},
  {5,6},
  {0,7},
  {7,8},
  {8,9},
  {9,10},
  {8,11},
  {11,12},
  {12,13},
  {8,14},
  {14,15},
  {15,16},
}

local namebonemapping = 
{
  ["Pelvis"] = 0,
  ["RightUpLeg"] = 4,
  ["RightLeg"] = 5,
  ["RightFoot"] = 6,
  ["LeftUpLeg"] = 1,
  ["LeftLeg"] = 2,
  ["LeftFoot"] = 3,
  ["Spine1"] = 7,
  ["Spine2"] = 8,
  ["Neck"] = 9,
  ["Head"] = 10,
  ["LeftArm"] = 14,
  ["LeftForeArm"] = 15,
  ["LeftHand"] = 16,
  ["RightArm"] = 11,
  ["RightForeArm"] = 12,
  ["RightHand"] = 13,
}

local g_w = 800;
local g_h = 800;

function poseestimates:Initialize()  
  self.inmat = ncnn.Mat();
  self.outmat = ncnn.Mat();
  self.net = ncnn.Net();
  self.net:LoadParam("docs:ncnn/ncnn.proto");
  self.net:LoadModel("docs:ncnn/ncnn.bin");
  
  self.renders = {}
  self.nodes = {}
  self.trans = {}
end

function poseestimates:redirect(points2d)
  local result = {}
--spine
  result[1] = (points2d[17]+points2d[19])/2;
  result[2] = (points2d[18]+points2d[20])/2;
--rleg
  result[3] =   points2d[19];
  result[4] =    points2d[20];
  result[5] =    points2d[23];
  result[6] =    points2d[24];
  result[7] =    points2d[27];
  result[8] =    points2d[28];
--lleg
  result[9] = points2d[17];
  result[10] =points2d[18];
  result[11] =points2d[21];
  result[12] =points2d[22];
  result[13] =points2d[25];
  result[14] =points2d[26];
--xiong
  result[15] = (points2d[5]+points2d[7])/2;
  result[16] = (points2d[6]+points2d[8])/2;
--bozi
  result[17] = points2d[3];
  result[18] = points2d[4];
--head
  result[19] =  points2d[1];
  result[20] =  points2d[2];
--LARM
  result[21] = points2d[5]; 
  result[22] = points2d[6]; 
  result[23] = points2d[9]; 
  result[24] = points2d[10];
  result[25] = points2d[13];
  result[26] = points2d[14];
--RARM
  result[27] =   points2d[7];
  result[28] =   points2d[8];
  result[29] =   points2d[11];
  result[30] =   points2d[12];
  result[31] =   points2d[15];
  result[32] =   points2d[16];

  local videsize = videodecet:GetVideoSize();
  local sw = g_w / videsize[1];
  local sh = g_h / videsize[2];
  
  for i=1, #result, 2 do
    result[i] = result[i] * sw;
    result[i+1] = result[i+1] * sw;
  end  
  
  return result;
end

function poseestimates:Estimates()
  local point2ds = videodecet:GetBodyPoints();--像素坐标
  local totalcount = table.getn(point2ds)
 
  --self:AttachBoneRender(1,mathfunction.vector3(0,0,0),mathfunction.vector3(3,3,3));
  if totalcount==0 then 
    return;
  end
  for i = 1 ,totalcount do
    if point2ds[i]==-1 then 
      LOG("no full bones!!! "..totalcount);
      return;
    end
  end
  local inputpointsdata = self:redirect(point2ds);
  for i = 1 ,32 do
   -- LOG(inputpointsdata[i]);
    inputpointsdata[i] = (inputpointsdata[i]-mean2d[i])/std2d[i];
  end
  
  self.inmat:Fill(inputpointsdata);  
  self.extractor = self.net:CreateExtractor();  
  local count = venuscore.IServicesSystem:GetThreadCount();
  self.extractor:SetNumThreads(count/2); 
  self.extractor:Input("inputs/enc_in", self.inmat);
  self.extractor:Extract("linear_model/add_1", self.outmat);
  local outarray = self.outmat:AsFloatArray();
  
  for i = 1 ,48 do
    outarray[i] = outarray[i]*std3d[i]+mean3d[i];
    outarray[i] = outarray[i]/1000;
  end
  
  self.positions = {}
  for i = 1 ,48, 3 do
    local pos = mathfunction.vector3(
      outarray[i],
      -outarray[i+1],
      outarray[i+2]);
    table.insert(self.positions, pos);
  end
  self.positions[0] = mathfunction.vector3();--插入根节点
  --Print_Table(self.positions);
end

function poseestimates:Render()
  for i = 1 ,16 do
		local fidx =	bonepair[i][1];
		local sidx = 	bonepair[i][2];
		local fpos = mathfunction.vector3(0,1.5,-5);
		local spos = mathfunction.vector3(0,1.5,-5);
		if fidx~= 0 then
			fpos = self.positions[fidx] + fpos;
		end
		if sidx~= 0 then
			spos = self.positions[sidx] + spos;
		end		
		self:AttachBoneLineRender(i,fpos,spos,1);
	end
end

function poseestimates:AttachBoneLineRender(index,pos1,pos2,scale)
	local dir = pos2 - pos1;
	local midpos = (pos2+pos1)/2;
	local length = dir:Length();
	local otherscale = length/4;
	dir:NormalizeSelf();

	local rotation = mathfunction.Quaternion();
	rotation:AxisToAxis(mathfunction.vector3(0,0,1),dir);

	if self.trans[index]==nil then

    local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
    local node = scene:CreateNode(apolloengine.Node.CT_NODE);
		--local node = apolloengine.Node();
    local cube = node:CreateComponent(apolloengine.Node.CT_RENDER);
    local trans = node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
		cube:PushMetadata(
		apolloengine.RenderObjectMaterialMetadata(
			apolloengine.PathMetadata("comm:documents/material/lightingonly.material")));  
		cube:PushMetadata(
			apolloengine.RenderObjectMeshFileMetadate("comm:documents/model/cube.mesh"));  
		cube:CreateResource();

		
		table.insert(self.renders, cube);
		table.insert(self.nodes, node);
		table.insert(self.trans, trans);		
	end
	
	self.trans[index]:SetLocalScale(mathfunction.vector3(otherscale,otherscale,length));
	self.trans[index]:SetLocalPosition(midpos);
	self.trans[index]:SetLocalRotation(rotation);

end

function poseestimates:VaildBone(name)
  return nil ~= namebonemapping[name];
end

function poseestimates:GetDirection(j1, j2)
  local index1 = namebonemapping[j1];
  local index2 = namebonemapping[j2];
  local pos1 = self.positions[index1];
  local pos2 = self.positions[index2];
  local dir = pos2 - pos1;
  dir:NormalizeSelf();
  --LOG("new direction form "..j1.." to "..j2.." is "..tostring(dir));
  return dir;
end


return poseestimates;