--local torch = require "torch"
local torch = require "torch"
local Object = require "classic"

local PolynomialFit = Object:extend();

function PolynomialFit:NormaliseSampleValues(samplevalues)

  local total = 0.0;
  for i=1,#samplevalues do
    total = total+samplevalues[i];
  end
  local avg = total/#samplevalues;
  
  local diff = 0;
  for i=1,#samplevalues do
    diff = diff+(samplevalues[i] - avg)*(samplevalues[i] - avg);
  end
  diff = diff/#samplevalues;
  
  self.avg = avg;
  self.diff = diff;
  
  local finalvalues = {}
  for i=1,#samplevalues do
    finalvalues[i] = (samplevalues[i] - self.avg)/self.diff;
  end
  return finalvalues;
end

function PolynomialFit:NormaliseInput(x)
  return (x-self.avg)/self.diff;
end

function PolynomialFit:Initialize(gtvalues, samplevalues, count,x0 , y100,dy100)
  self.count = count;
  self.xvalues = self:NormaliseSampleValues( samplevalues);
  self.yvalus = gtvalues;

  self.bonepair = bonepair
  self.len_q = window
  self.joints = joints
  
  self.X = torch.Tensor(#self.xvalues,self.count)
  for i=1,#self.xvalues do
    for j = 1,self.count  do
      self.X[i][j] = self.xvalues[i]^(j-1);
    end
  end
  
  self.Y = torch.Tensor(#self.yvalus,1)
  for i=1,#self.xvalues do
    self.Y[i][1] = self.yvalus[i]
  end
  
  self.largleft = nil;
  self.largright = nil;
  self.weightlambda = nil;
  
  if x0~=nil then
    x0 = self:NormaliseInput(x0);
    self.x0t = torch.Tensor(1,self.count);
    for i = 1,self.count  do
      self.x0t[1][i] = x0^(i-1);
    end
    
    self.dx0t = torch.Tensor(1,self.count):fill(0);
    for i = 2,self.count  do
      self.dx0t[1][i] = (i-1)*x0^(i-2);
    end
    
    self.largleft = torch.Tensor(self.count+2,self.count+2):fill(0);
    self.largleft[{{1,self.count},{1,self.count}}] = self.X:transpose(1, 2)*self.X;
    
    self.largleft[{{1,self.count},self.count+1}] = self.x0t:transpose(1, 2);
    self.largleft[{self.count+1,{1,self.count}}] = self.x0t;
    
    self.largleft[{{1,self.count},self.count+2}] = self.dx0t:transpose(1, 2);
    self.largleft[{self.count+2,{1,self.count}}] = self.dx0t;
    
   
    
    self.largright = torch.Tensor(self.count+2,1):fill(0);
    self.largright[{{1,self.count},1}] = self.X:transpose(1, 2) * self.Y
    self.largright[{self.count+1,1}] = y100;
    
    self.largright[{self.count+2,1}] = dy100;
    
    local inverseL = torch.inverse(self.largleft);
    
    self.weightlambda = inverseL*self.largright;
    
    local tempright = self.largleft*self.weightlambda;
    local diff = tempright - self.largright;
    LOG(diff);
    
    self.W = torch.Tensor(self.count,1);
    self.W[{{1,self.count},1}] = self.weightlambda[{{1,self.count},1}];
  else
    self.W = self:pinv(self.X:transpose(1, 2)*self.X) * self.X:transpose(1, 2) * self.Y
  end
  
end

function PolynomialFit:GetD(x)
  x = self:NormaliseInput(x);
  local ret = 0;
  for i=2,self.count do
    ret = ret+ (i-1)*x^(i-2)*self.W[i];
  end
  return ret;
end

function PolynomialFit:Caculate(x)
  x = self:NormaliseInput(x);
  self.Feature = torch.Tensor(1,self.count);
  for i=1,self.count do
    self.Feature[1][i] = x^(i-1);
  end
  
  return self.Feature*self.W;
end

function PolynomialFit:tbl_push(tbl, val)
  table.insert(tbl, self:deep_copy(val))
  if #tbl > self.len_q then
    table.remove(tbl, 1)
  end
end

function PolynomialFit:get_latest(tbl)
  local latest = self:deep_copy(tbl[#tbl])
  return latest
end

function PolynomialFit:deep_copy(orig)
  local copy
  if type(orig) == "table" then
    copy = {}
    for orig_key, orig_value in next, orig, nil do
      copy[self:deep_copy(orig_key)] = self:deep_copy(orig_value)
    end
    setmetatable(copy, self:deep_copy(getmetatable(orig)))
  else
    copy = orig
  end
  return copy
end


function PolynomialFit:pinv(A)
--[[
  local U = {} 
  local S = {} 
  local V = {} 
  U, S, V = torch.svd(A)

  for i = 1, S:size(1) do
    if S[i] > 1e-8 or S[i] < -1e-8 then
      S[i] = 1 / S[i]
    end
  end

  local A_inv = V * torch.diag(S):transpose(1, 2) * U:transpose(1, 2)
  return A_inv]]
  return torch.inverse(A);
end

return PolynomialFit
