local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
require "venusdebug"
require "utility"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local poseestimate = require "avatar.poseestimates"


local avatartest = {}

function avatartest:_CreateSmallCube()
  self.cubes = self.cubes or {};
  local target = apollonode.MeshNode();
  target:CreateResource(
    "comm:documents/model/cube.mesh", 
    "comm:documents/material/lightingonly.material");
  target:SetBindBox(
    mathfunction.Aabbox3d(
      mathfunction.vector3(-0.5,-0.5,-0.5),
      mathfunction.vector3(0.5,0.5,0.5)));
  target:SetCull(false);
  target:SetLocalScale( mathfunction.vector3(0.13,0.13,0.13) );
  table.insert(self.cubes, target);
  return target;
end



function avatartest:_FindPosition(name)
  local data = self.bones[name];
  return data.trans:GetWorldPosition();
end

function avatartest:_InitBones(root, rootpos)
  self.bones = self.bones or {};
  local nodename = root:GetName();
  local data = {}
  data.trans = root:GetComponent(apolloengine.Node.CT_TRANSFORM);
  local pos = data.trans:GetLocalPosition();
  --pos:Set(pos:x(), pos:y(), 0);
  --data.trans:SetLocalPosition(pos);
  data.rotation = data.trans:GetLocalRotation();
  self.bones[nodename] = data;
  local childrens = root:GetChildrens();
  for _, value in pairs(childrens) do
    self:_InitBones(value, rootpos);
  end 
end

--当前模型和姿态估计根骨骼坐标系不一致，由于转动轴的不一致没办法直接计算旋转，需要转换
function avatartest:_CaculateRotation(root)
  local rootname = root:GetName();
  local rootdata = self.bones[rootname];
  local rootpos = rootdata.trans:GetWorldPosition();
  local childrens = root:GetChildrens();
  for childname, childnode in pairs(childrens) do    
    local childdata = self.bones[childname];
    local childpos = childdata.trans:GetWorldPosition();
    local basedir = childpos - rootpos;
    local oldlen = basedir:Length();
    --basedir = basedir:Normalize();
    --LOG("old direction form "..rootname.." to "..childname.." is "..tostring(basedir).." lenght is "..tostring(oldlen));
    local newdir = poseestimate:GetDirection(rootname, childname);
    --local rotation = mathfunction.Mathutility:AxisToAxis(basedir, newdir);
    --rotation = childdata.rotation * rotation;
    local worldpos = rootpos + newdir * oldlen;
    --childdata.trans:SetLocalRotation(rotation);
    childdata.trans:SetWorldPosition(worldpos);
    local newpos = childdata.trans:GetWorldPosition();
    local caldir = newpos - rootpos;
    local newlen = caldir:Length();
    caldir = caldir:Normalize();
    --LOG("caculated rotation is "..tostring(rotation));
    --LOG("caculated direction form "..rootname.." to "..childname.." is "..tostring(caldir).." lenght is "..tostring(newlen));
    --LOG("-----------------------------------------------------------------------------")
    self:_CaculateRotation(childnode);
  end  
end

local radiusscale = math.pi / 180;
function avatartest:_CreateJoint(joint, lx, ux, ly, uy, lz, uz, iscube)
  self.render:CreateJoint(
    joint,
    mathfunction.vector3(lx * radiusscale, ly * radiusscale, lz * radiusscale),
    mathfunction.vector3(ux * radiusscale, uy * radiusscale, uz * radiusscale));
  
  if iscube then
    local joint = self.model:GetJoint(joint);
    local cube = self:_CreateSmallCube();
    table.insert(self.cubes, cube);
    joint:AttachNode(cube);
  end  
end


--逻辑模型需要按照3d姿态估计的Tpose的骨骼节点相对位置来制作，按理说应该在xy平面之上
--2d到3d的映射位置不相符，部分信息丢失，导致现在识别出来的驱赶数据不准确
--模型中骨骼的位置与2d追踪的位置不相符，导致计算出来的骨骼位置存在问题，导致最后ik出来的整体躯干不好
function avatartest:Initialize()
  poseestimate:Initialize();

  self.direct = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
  self.direct:SetColor(
    mathfunction.vector3(1,1,1));
  self.direct:SetLocalDirection(
    mathfunction.vector3(0,-1,-1));

  self.logic = apollonode.ModelNode();
  self.logic:CreateResource("docs:avatar/pose/model");
  --self.logic:SetLocalPosition(0,-2.5,-5);
  self.logic:SetShow(false);
  
  local roots = self.logic:GetBoneRoots();
  local root = roots["Hips"];  
  local childrens = root:GetChildrens();
  for childname, childnode in pairs(childrens) do
    self:_InitBones(childnode);
  end
  
  self.render = apollonode.ModelNode();
  self.render:CreateResource("docs:avatar/ik/model");
  self.render:SetLocalPosition(0,-2.5,-5);
  --self.render:SetShow(false);
  
  self:_CreateJoint("Hips", 0, 0, 180, -180, 0, 0, false);
  
  self:_CreateJoint("Spine", -40, 40, -40, 40, -40, 40, false);
  self.render:CreateEffector("Spine");
  
  self:_CreateJoint("Spine1", -40, 40, -40, 40, -40, 40, false); --unity chest
  self:_CreateJoint("Spine2", -20, 20, -20, 20, -20, 20, false); --unity upper chest  
  self.render:CreateEffector("Spine1");
  
  self:_CreateJoint("Neck", -40, 40, -40, 40, -40, 40, false); --unity neck
  self:_CreateJoint("Head", -40, 40, -40, 40, -40, 40, false); --unity head
  self.render:CreateEffector("Neck");
  self.render:CreateEffector("Head");
  
  self:_CreateJoint("LeftShoulder", 0, 0, -15, 15, -15, 30, false); --shoulder
  self:_CreateJoint("LeftArm", -90, 90, -100, 100, -60, 100, false); --arm
  self:_CreateJoint("LeftForeArm", -90, 90, -80, 80, 0, 0, false); --forcearm  
  self:_CreateJoint("LeftHand", 0, 0, -40, 40, -80, 80, false); --forcearm
  self.render:CreateEffector("LeftArm");
  self.render:CreateEffector("LeftForeArm");
  self.render:CreateEffector("LeftHand");  
  
  self:_CreateJoint("RightShoulder", 0, 0, -15, 15, -15, 30, false); --shoulder
  self:_CreateJoint("RightArm", -90, 90, -100, 100, -60, 100, false); --arm
  self:_CreateJoint("RightForeArm", -90, 90, -80, 80, 0, 0, false); --forcearm
  self:_CreateJoint("RightHand", 0, 0, -40, 40, -80, 80, false); --forcearm
  self.render:CreateEffector("RightArm");
  self.render:CreateEffector("RightForeArm");
  self.render:CreateEffector("RightHand");
  
  self:_CreateJoint("Pelvis", -40, 40, -40, 40, -40, 40, false);
  self.render:CreateEffector("Pelvis");
  
  self:_CreateJoint("LeftUpLeg", -90, 90, -60, 60, -60, 60, false);
  self:_CreateJoint("LeftLeg", -80, 80, 30, 30, -0, 0, false);
  self:_CreateJoint("LeftFoot", -50, 50, 0, 0, -30, 30, false);
  self.render:CreateEffector("LeftUpLeg");
  self.render:CreateEffector("LeftLeg");
  self.render:CreateEffector("LeftFoot");  
  
  self:_CreateJoint("RightUpLeg", -90, 90, -60, 60, -60, 60, false);
  self:_CreateJoint("RightLeg", -80, 80, 30, 30, -0, 0, false);
  self:_CreateJoint("RightFoot", -50, 50, 0, 0, -30, 30, false);
  self.render:CreateEffector("RightUpLeg");
  self.render:CreateEffector("RightLeg");
  self.render:CreateEffector("RightFoot");  
  
  self.render:SetRootJoint("Hips");
  self.render:LinkJoints("Hips", "Spine");
  self.render:LinkJoints("Spine", "Spine1");
  self.render:LinkJoints("Spine1", "Spine2");  
  
  self.render:LinkJoints("Spine2", "Neck");
  self.render:LinkJoints("Neck", "Head");
  
  self.render:LinkJoints("Spine2", "LeftShoulder");
  self.render:LinkJoints("LeftShoulder", "LeftArm");
  self.render:LinkJoints("LeftArm", "LeftForeArm");
  self.render:LinkJoints("LeftForeArm", "LeftHand");
  
  self.render:LinkJoints("Spine2", "RightShoulder");
  self.render:LinkJoints("RightShoulder", "RightArm");
  self.render:LinkJoints("RightArm", "RightForeArm");
  self.render:LinkJoints("RightForeArm", "RightHand");
  
  self.render:LinkJoints("Hips", "Pelvis");
  
  self.render:LinkJoints("Pelvis", "LeftUpLeg");
  self.render:LinkJoints("LeftUpLeg", "LeftLeg");
  self.render:LinkJoints("LeftLeg", "LeftFoot");
  
  self.render:LinkJoints("Pelvis", "RightUpLeg");
  self.render:LinkJoints("RightUpLeg", "RightLeg");
  self.render:LinkJoints("RightLeg", "RightFoot");
  
  self.render:BuildKinematics();
  return true;
end
local i = 0;
function avatartest:Update(def)
  poseestimate:Estimates()
  local roots = self.logic:GetBoneRoots();
  local root = roots["Hips"];  
  local childrens = root:GetChildrens();
  for childname, childnode in pairs(childrens) do
    self:_CaculateRotation(childnode);
  end  
  poseestimate:Render();
  local p = self:_FindPosition("Pelvis");
  local s1 = self:_FindPosition("Spine1");
  local s2 = self:_FindPosition("Spine2");
  local n = self:_FindPosition("Neck");
  local h = self:_FindPosition("Head");  
  local lfa = self:_FindPosition("LeftForeArm");
  local la = self:_FindPosition("LeftArm");
  local lh = self:_FindPosition("LeftHand");
  local rfa = self:_FindPosition("RightForeArm");
  local ra = self:_FindPosition("RightArm");
  local rh = self:_FindPosition("RightHand");
  local lul = self:_FindPosition("LeftUpLeg");
  local ll = self:_FindPosition("LeftLeg");
  local lf = self:_FindPosition("LeftFoot");
  local rul = self:_FindPosition("RightUpLeg");
  local rl = self:_FindPosition("RightLeg");
  local rf = self:_FindPosition("RightFoot");
  
  local m = self.render:GetWorldTransform();
  
  self.render:SetTarget("Pelvis", p * m);
  self.render:SetTarget("Spine", s1 * m);
  self.render:SetTarget("Spine1", s2 * m);
  self.render:SetTarget("Neck", n * m);
  self.render:SetTarget("Head", h * m);
  self.render:SetTarget("LeftForeArm", lfa * m);
  self.render:SetTarget("LeftArm", la * m);
  self.render:SetTarget("LeftHand", lh * m);
  self.render:SetTarget("RightForeArm", rfa * m);
  self.render:SetTarget("RightArm", ra * m);
  self.render:SetTarget("RightHand", rh * m);
  self.render:SetTarget("LeftUpLeg", lul * m);
  self.render:SetTarget("LeftLeg", ll * m);
  self.render:SetTarget("LeftFoot", lf * m);
  self.render:SetTarget("RightUpLeg", rul * m);
  self.render:SetTarget("RightLeg", rl * m);
  self.render:SetTarget("RightFoot", rf * m);  
  --for i=1, 10 do
    local e = self.render:UpdateKinematics();
    LOG(e);
  --end  
end


return avatartest;