local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local videodecet = require "videodecet"
local soundplayer = require "soundplayer"
local faceinfo = require "videodecet.faceinfo"
local mathfunction = require "mathfunction"
local math = require "math"
local venuscore = require "venuscore"

local dollymain={};
dollymain.time=0;
dollymain.t=1;
--缩放时间点列表
dollymain.basetime = {0.0,1.95,2.0,2.05,  2.1,3.4,  3.45,3.6,  3.65,5.0,5.5,  5.55,6.0,6.55,  6.6,7.05,7.2,  7.3,15.0};
--与缩放时间点相对应的尺寸
dollymain.scale = {0.0,0.05,0.08,0.08,  0.18,0.2,  0.33,0.35,  0.5,0.55,0.6,  0.78,0.8,0.85,  1.05,1.08,1.1,  1.4,1.5};
--划分几个关键时间点 
dollymain.part = 19;
function dollymain:_arrayToVec2(pt)
  return mathfunction.vector2(pt[1],pt[2]);
end

function dollymain:Initialize(camera,config)
  self.time = 0;
  self.maincamera = camera;
  self.post = self.maincamera:CreatePostEffect();
  self.lpath = venuscore.IFileSystem:PathAssembly("docs:filter/dramatic/filter/resource");
  
  self.post:CreateResource(self.lpath.."/dolly.lua"); 
  self.post:RegisterParameter("UNIFORM_CENTER",self.lpath.."/material/dramadolly.material");
  self.post:RegisterParameter("UNIFORM_SCALE",self.lpath.."/material/dramadolly.material");
  self.post:UNIFORM_SCALE(mathfunction.vector1(1.0));
  self.post:UNIFORM_CENTER(mathfunction.vector2(0.0, 0.0));  
  
  self.soundpath = "ress:"..config.filter.Sound;
  self.spath = venuscore.IFileSystem:PathAssembly(self.soundpath);
  --LOG(venuscore.IFileSystem:PathAssembly(self.soundpath));
  self.soundplayerDetect = soundplayer();
  local res = self.soundplayerDetect:LoadSound(self.spath);
  self.soundplayerDetect:PlaySound(0);   
  
  --self.maincamera:AttachPostEffect(self.post);
end

function dollymain:Update(def)
  self.time = self.time + def;
  local faces = videodecet:GetFaces();
  local maxFaceNum = 1;
  if faces and faces[1] then
    local faceinfo = faces[1];
    local keypoints = faceinfo:GetKeypointArray();
    self.center = (self:_arrayToVec2(keypoints[78])+self:_arrayToVec2(keypoints[75]))*0.5;
  else
    self.center = mathfunction.vector2(0.0, 0.0);
  end
  if(self.time>self.basetime[self.part]) then
    self.time = 0.0;
    self.t = 1;
  end
  if(self.time>=self.basetime[self.t]) then
    self.t =self.t+1;
  end
  local newscale = (self.scale[self.t]-self.scale[self.t-1])*(self.time-self.basetime[self.t-1])/(self.basetime[self.t]-self.basetime[self.t-1])+self.scale[self.t-1];
  self.post:UNIFORM_SCALE(mathfunction.vector1(newscale));
  self.post:UNIFORM_CENTER(self.center);
end

function dollymain:OnRecordStart()
  self.time = 0;
  self.t = 1;
  self.soundplayerDetect:StopSound();
  self.soundplayerDetect:PlaySound(0);
end

function dollymain:Exit()
  self.post:Disable();
  self.maincamera:DeletePostEffect(self.post);
  self.post = nil;
  self.soundplayerDetect:StopSound();
end

return dollymain;
