package com.amazon.alta.h2shared.aidl;

import com.amazon.alta.h2shared.aidl.genericaidl.IStatusIPCCallback;
import com.amazon.alta.h2shared.aidl.genericaidl.IStringIPCCallback;
import com.amazon.alta.h2shared.aidl.getuser.IUserIPCCallback;
import com.amazon.alta.h2shared.aidl.getusers.IGetUsersIPCCallback;
import com.amazon.alta.h2shared.models.AmazonUser;
import com.amazon.alta.h2shared.models.HouseholdRole;
import com.amazon.alta.h2shared.models.SecureSettingsKey;
import com.amazon.alta.h2shared.models.TokenType;
import com.amazon.alta.h2shared.models.UserMetadata;
import com.amazon.alta.h2shared.models.UserState;

// Declare the service interface.
//
// New API definitions need to go at the bottom of this file - will break backwards compatibility otherwise.
//
oneway interface IH2ClientService {
    // AmazonHousehold APIs
    void getUserByAmazonId(in String amazonId, in IUserIPCCallback callback);
    void getUserByAndroidId(in int androidId, in IUserIPCCallback callback);

    // AmazonHouseholdManager APIs
    void addUser(in String agentId, in UserMetadata userData, in IUserIPCCallback callback);
    void updateUser(in String agentId, in AmazonUser user, in IUserIPCCallback callback);
    void addWarmUser(in String agentId, in String directedId, in String token, in IUserIPCCallback callback);

    // H2HouseholdManager APIs
    void syncHouseholdFromCloud(in String agentId, in IStatusIPCCallback callback);
    void getUsers(in UserState state, in HouseholdRole role, in IGetUsersIPCCallback callback);
    void addCloudUserToDevice(in String agentId, in String userId, in IUserIPCCallback callback);
    void addCloudAdultToDevice(in String agentId, in String userId, in String token, in IUserIPCCallback callback);
    void removeUserFromDevice(in String userId, in boolean keepData, in IUserIPCCallback callback);
    void removeUserFromHousehold(in String agentId, in String userId, in IUserIPCCallback callback);
    void registerPendingUser(in String userId, in String email, in String password, in IUserIPCCallback callback);
    void registerPendingUserWithToken(in String userId, in String token, in TokenType tokenType, in IUserIPCCallback callback);

    // H2HouseholdManager APIs (for OOBE)
    void addAndroidAccount(in String agentId, in AmazonUser user, in IUserIPCCallback callback);
    void removeAndroidAccount(in String agentId, in AmazonUser user, in IUserIPCCallback callback);
    void registerUserWithExistingAndroidId(in String agentId, in AmazonUser user, in String password, in IUserIPCCallback callback);

    // H2HouseholdManager - Peek use cases
    void getPeekResult(in UserState state, in HouseholdRole role, in IGetUsersIPCCallback callback);
    void peekHousehold(in String agentId, in String directedId, in String token, in IUserIPCCallback callback);
}
