
//#ifdef GL_ES//for discriminate GLES & GL
//#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
//#else
//precision mediump float;
//#endif
//#else
//#define highp
//#define mediump
//#define lowp
//#endif


//viewport: w=540 h= 960
varying highp vec2 textureCoordinate; 
// varying highp vec2 textureCoordinate2; 
// varying highp vec2 textureCoordinate3; 

varying highp vec4 textureShift_1; 
varying highp vec4 textureShift_2; 
varying highp vec4 textureShift_3; 
varying highp vec4 textureShift_4; 

// uniform sampler2D inputImageTexture; 
uniform sampler2D VIDEO; 
#define  inputImageTexture VIDEO
uniform sampler2D inputImageTexture2; 
uniform sampler2D inputImageTexture3; 
uniform lowp float blurAlpha; //0.59
uniform highp float sharpen;//0.35
 
void main() 
{ 
	lowp vec4 iColor = texture2D(inputImageTexture, textureCoordinate); 
	// lowp vec4 meanColor = texture2D(inputImageTexture2, textureCoordinate2); 
	// lowp vec4 varColor = texture2D(inputImageTexture3, textureCoordinate3); 
	lowp vec4 meanColor = texture2D(inputImageTexture2, textureCoordinate); 
	lowp vec4 varColor = texture2D(inputImageTexture3, textureCoordinate); 

	lowp float theta = 0.1; 
	mediump float p = clamp((min(iColor.r, meanColor.r - 0.1) - 0.2) * 4.0, 0.0, 1.0); 
	mediump float meanVar = (varColor.r + varColor.g + varColor.b) / 3.0; 
	mediump float kMin; 
	lowp vec3 resultColor; 
	kMin = (1.0 - meanVar / (meanVar + theta)) * p * blurAlpha; 
	resultColor = mix(iColor.rgb, meanColor.rgb, kMin); 
	 
	// highp float sum = 0.25*iColor.g;
	// sum += 0.125*texture2D(inputImageTexture,textureCoordinate+vec2(-widthOffset,0.0)).g;
	// sum += 0.125*texture2D(inputImageTexture,textureCoordinate+vec2(widthOffset,0.0)).g;
	// sum += 0.125*texture2D(inputImageTexture,textureCoordinate+vec2(0.0,-heightOffset)).g;
	// sum += 0.125*texture2D(inputImageTexture,textureCoordinate+vec2(0.0,heightOffset)).g;
	// sum += 0.0625*texture2D(inputImageTexture,textureCoordinate+vec2(widthOffset,heightOffset)).g;
	// sum += 0.0625*texture2D(inputImageTexture,textureCoordinate+vec2(-widthOffset,-heightOffset)).g;
	// sum += 0.0625*texture2D(inputImageTexture,textureCoordinate+vec2(-widthOffset,heightOffset)).g;
	// sum += 0.0625*texture2D(inputImageTexture,textureCoordinate+vec2(widthOffset,-heightOffset)).g;

	mediump float sum = 0.25*iColor.g;
	sum += 0.125 *texture2D(inputImageTexture,textureShift_1.xy).g;
	sum += 0.125 *texture2D(inputImageTexture,textureShift_1.zw).g;
	sum += 0.125 *texture2D(inputImageTexture,textureShift_2.xy).g;
	sum += 0.125 *texture2D(inputImageTexture,textureShift_2.zw).g;
	sum += 0.0625*texture2D(inputImageTexture,textureShift_3.xy).g;
	sum += 0.0625*texture2D(inputImageTexture,textureShift_3.zw).g;
	sum += 0.0625*texture2D(inputImageTexture,textureShift_4.xy).g;
	sum += 0.0625*texture2D(inputImageTexture,textureShift_4.zw).g;



	float hPass = iColor.g-sum+0.5;
	float flag = step(0.5, hPass);
    highp vec3 color = mix(max(vec3(0.0), (2.0*hPass + resultColor - 1.0)), min(vec3(1.0), (resultColor + 2.0*hPass - 1.0)), flag);


    color = mix(resultColor.rgb, color.rgb, sharpen);

    gl_FragColor = vec4(color, iColor.a);
}
