precision highp float;

attribute vec4 position;
attribute vec2 uv;

uniform highp float texelWidthOffset; //0.0
uniform highp float texelHeightOffset; //0.0026042 即1.5/h
varying vec2 textureCoordinate; 
varying vec4 textureShift_1; 
varying vec4 textureShift_2; 
varying vec4 textureShift_3; 
varying vec4 textureShift_4; 

uniform mat4 u_MVP;

void main(void)
{
    // gl_Position = u_MVP * position;
    gl_Position = sign(vec4(position.xy, 0.0, 1.0));
    textureCoordinate = uv.st;

	vec2 singleStepOffset = vec2(texelWidthOffset, texelHeightOffset); 
	textureCoordinate = uv.st; 
	textureShift_1 = vec4(uv.st - singleStepOffset, uv.st + singleStepOffset); 
	textureShift_2 = vec4(uv.st - 2.0 * singleStepOffset, uv.st + 2.0 * singleStepOffset); 
	textureShift_3 = vec4(uv.st - 3.0 * singleStepOffset, uv.st + 3.0 * singleStepOffset); 
	textureShift_4 = vec4(uv.st - 4.0 * singleStepOffset, uv.st + 4.0 * singleStepOffset); 
}
