local exports = exports or {}
local blurScript = {}
blurScript.__index = blurScript

function blurScript.new(construct, ...)
    local self = setmetatable({}, blurScript)
    self.cameras = {}
    self.deformations = {}
    self.allRenders = {}
    self.renderTargets = {}
    self.fullScreenCam = nil
    self.outputRT = nil
    self.finalRenderer = nil
    self.fullScreenWidth = 720
    self.fullScreenHeight = 1280
    self.blurResolution = {324,576,360,480,360,360}
    self.renderWidth_blur = self.blurResolution[1]
    self.renderHeight_blur = self.blurResolution[2]
    if construct and blurScript.constructor then blurScript.constructor(self, ...) end
    return self
end



function blurScript:onStart(sys)
    sys:addEventType(Amaz.AppEventType.SetEffectIntensity)
    local scene = sys.scene
    local entities = scene.entities
    local allCameras = {}
    for i = 0, entities:size() - 1 do
        local entity = entities:get(i)
        local renderer = entity:getComponent("MeshRenderer")
        if renderer ~= nil then
            table.insert(self.allRenders, renderer)
        end
        local camera = entity:getComponent("Camera")
        if camera ~= nil then
            table.insert(allCameras, camera)
        end
    end
    -- print("##############")
    for i = 1, #self.allRenders do
        local renderer = self.allRenders[i]
        for j = 1, #allCameras do
            if allCameras[j]:isLayerVisible(renderer.entity.layer) then
            
                table.insert(self.cameras, allCameras[j])
                local camName = allCameras[j].name
                if string.find(camName,"Final") ~= nil then
                    self.fullScreenCam = allCameras[j]
                    self.finalRenderer = renderer
                    -- print("fullScreen camera name:"..camName)
                else
                    table.insert(self.renderTargets, allCameras[j].renderTexture)
                    -- print("blur camera name:"..camName)
                end                
            end
        end
    end
    self.outputRT = sys.scene:getOutputRenderTexture()
end

local function checkResolutionChange(self)
    
        local newScreenW = self.outputRT.width
        local newScreenH = self.outputRT.height
        -- print("new screen W is:"..newScreenW)
        -- print("new screen H is:"..newScreenH)
        -- 检测分辨率是否改变
        if(newScreenW ~= self.fullScreenWidth or newScreenH ~= self.fullScreenHeight) then
            local isFullScreen = true
            local isRaio_11 = false
            -- 多比例判断
            if(newScreenW/newScreenH < 10 / 16) then
                isFullScreen = true
                isRaio_11 = false
            elseif(newScreenW/newScreenH < 14 / 16) then
                isFullScreen = false
                isRaio_11 = false   
            else
                isFullScreen = false
                isRaio_11 = true          
            end
            -- 渲染size适配多比例
            for i = 1, #self.renderTargets do
                local target = self.renderTargets[i]
                if(true == isFullScreen) then
                    target.width = self.blurResolution[1]
                    target.height = self.blurResolution[2]
                elseif(false == isRaio_11) then
                    target.width = self.blurResolution[3]
                    target.height = self.blurResolution[4]
                else
                    target.width = self.blurResolution[5]
                    target.height = self.blurResolution[6]
                end                        
                self.renderWidth_blur = target.width
                self.renderHeight_blur = target.height
                -- print("renderWidth_blur is:"..self.renderWidth_blur)
                -- print("renderHeight_blur is:"..self.renderHeight_blur)
            end    

            -- 更新uniform 参数
            for i = 1, #self.allRenders do
                local render = self.allRenders[i]
                local renderName = render.name
                if(string.find(renderName,"state") ~= nil) then
                    if(string.find(renderName,"2") ~= nil or string.find(renderName,"5") ~= nil) then
                        render.materials:get(0).properties:setFloat("texelWidthOffset", 0.0)
                        render.materials:get(0).properties:setFloat("texelHeightOffset", 1.5/self.renderHeight_blur)
                    elseif (string.find(renderName,"3") ~= nil or string.find(renderName,"6") ~= nil) then
                        render.materials:get(0).properties:setFloat("texelWidthOffset", 1.5/self.renderWidth_blur)
                        render.materials:get(0).properties:setFloat("texelHeightOffset", 0.0) 
                    elseif (string.find(renderName,"Final") ~= nil)  then
                        render.materials:get(0).properties:setFloat("widthOffset", 1.0/newScreenW)
                        render.materials:get(0).properties:setFloat("heightOffset", 1.0/newScreenH) 
                    end                                                             

                end
            end  
            self.fullScreenWidth = newScreenW
            self.fullScreenHeight = newScreenH       
        end
    
end

function blurScript:onUpdate(sys, deltaTime)

    checkResolutionChange(self)

    -- for i = 1, #deformations do
    --     deformations[i]:getComponent("MeshRenderer").enabled = false
    -- end
    -- local count = Calibrate.faceCount
    -- if #deformations - 1 < count then
    --     count = #deformations - 1
    -- end

    -- if count == 0 then
    --     deformations[1]:getComponent("MeshRenderer").enabled = true
    -- else
    --     -- print("####start")
    --     for i = 1, count do
    --         local camera = cameras[i + 1]
    --         -- print("i: " .. (count % 2 + i) % 2 + 1)
    --         camera.renderTexture = renderTargets[(count % 2 + i) % 2 + 1]
    --         local renderer = deformations[i + 1]:getComponent("MeshRenderer")
    --         renderer.enabled = true
    --         -- print("name: " .. deformations[i + 1].name)
    --         if i > 1 then
    --             renderer.materials:get(0).properties:setTex("_tex", renderTargets[(count % 2 + i + 1) % 2 + 1])
    --             -- print("j: " .. (count % 2 + i + 1) % 2 + 1)
    --         end
    --     end
    --     -- print("####end")
    -- end
end

function blurScript:onEvent(sys, event)
    -- print("event.type = " .. event.type .. ", event.name: " .. "SetEffectIntensity" .. ", event.key: " .. event.args:get(0) .. ", event.value: " ..  event.args:get(1))

    if event.type == Amaz.AppEventType.SetEffectIntensity then
        if event.args:get(0) == "intensity" then
            -- 设置磨皮程度
            -- self.smoothMaterial.properties:setFloat("blurAlpha", event.args:get(1))
            self.finalRenderer.materials:get(0).properties:setFloat("blurAlpha", event.args:get(1))
        elseif event.args:get(0) == "Internal_Whiten" then
            -- 设置美白程度
            -- self.smoothMaterial.properties:setFloat("whiten", event.args:get(1))
        elseif event.args:get(0) == "Internal_Sharpen" then
            -- 设置锐化程度
            self.finalRenderer.materials:get(0).properties:setFloat("sharpen", event.args:get(1))
            -- self.smoothMaterial.properties:setFloat("sharpen", event.args:get(1))
        end
    end
end

exports.blurScript = blurScript

return exports
