precision highp float;
varying highp vec2 uv0;
uniform sampler2D inputImageTexture;
uniform float sharpness;
uniform vec4 u_ScreenParams;
const int M = 1;
uniform float white_gam;
uniform float black_gam;

const mat3 rgb2ycbcr = mat3(
    0.299, -0.168736, 0.5,
    0.587, -0.331264, -0.418688,
    0.114, 0.5, -0.081312
);

vec3 rgb2gray = vec3(0.299, 0.587, 0.114);

const mat3 ycbcr2rgb = mat3(
    1.0, 1.0, 1.0,
    0.0, -0.344136, 1.772,
    1.402, -0.714136, 0.0
);

void main()
{
    vec2 step = vec2(1.0 / u_ScreenParams.x, 1.0 / u_ScreenParams.y);
    vec4 srcColor = texture2D(inputImageTexture, uv0);
    highp vec3 color = vec3(0);
    // float coef = (sum - 1.0) / ((2.0 * M + 1.0) * (2.0 * M + 1.0));

    float p1 = dot(rgb2gray, (texture2D(inputImageTexture, uv0 + step * vec2(-1, -1)).rgb));
    float p2 = dot(rgb2gray, (texture2D(inputImageTexture, uv0 + step * vec2(0, -1)).rgb));
    float p3 = dot(rgb2gray, (texture2D(inputImageTexture, uv0 + step * vec2(1, -1)).rgb));
    float p4 = dot(rgb2gray, (texture2D(inputImageTexture, uv0 + step * vec2(-1, 0)).rgb));
    float p5 = dot(rgb2gray, (srcColor.rgb));
    float p6 = dot(rgb2gray, (texture2D(inputImageTexture, uv0 + step * vec2(1, 0)).rgb));
    float p7 = dot(rgb2gray, (texture2D(inputImageTexture, uv0 + step * vec2(-1, 1)).rgb));
    float p8 = dot(rgb2gray, (texture2D(inputImageTexture, uv0 + step * vec2(0, 1)).rgb));
    float p9 = dot(rgb2gray, (texture2D(inputImageTexture, uv0 + step * vec2(1, 1)).rgb));

    float f1 = 2.0 * p5 - p4 - p6;
    float f2 = 2.0 * p5 - p2 - p8;
    float f3 = 2.0 * p5 - p3 - p7;
    float f4 = 2.0 * p5 - p1 - p9;

    float maxf = max(max(max(abs(f1), abs(f2)), abs(f3)), abs(f4));
    vec3 ycbcr = rgb2ycbcr * srcColor.rgb;

    // color = srcColor.rgb;

    float f = f1;
    if (abs(abs(f1) - maxf) <= 0.01)
        f = f1;
    else if (abs(abs(f2) - maxf) <= 0.01)
        f = f2;
    else if (abs(abs(f3) - maxf) <= 0.01)
        f = f3;
    else if (abs(abs(f4) - maxf) <= 0.01)
        f = f4;
    color = ycbcr2rgb * ((ycbcr + vec3(sharpness * f * 0.5, 0, 0)));
    // gl_FragColor = vec4(color, 1.0);
    gl_FragColor = vec4(color, srcColor.a);
    // gl_FragColor = abs(gl_FragColor - srcColor);
}
