local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "window.editor.command.content_manager"
local StateSelectAnimationCommand = CommandBase:extend("StateSelectAnimationCommand");

function StateSelectAnimationCommand:new(uuid, anipath, native_stateId)
    StateSelectAnimationCommand.super.new(self);
    self._uuid = uuid;
    self._aniPath =  anipath;
    self._stateId = native_stateId;
    self._prevMotion = nil;
    self._state = nil;
end

function StateSelectAnimationCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani then
        local state = ani:GetStateById(0, self._stateId);
        if state then
            self._state = state;
            local motion = ani:GetAnimationEntity(self._aniPath);
            if motion ~= nil then
                self._prevMotion = self._state.Motion;
                self._state:SetMotion(motion);
            end
        end
        
      end
    end
    self:EndCmd();
end

function StateSelectAnimationCommand:Undo()
    self:BeginCmd();
    if self._state then
        self._state:SetMotion(self._prevMotion);
    end
    self:EndCmd();
end

return StateSelectAnimationCommand;