local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local SetExitTimeCommand = CommandBase:extend("SetExitTimeCommand");

function SetExitTimeCommand:new(uuid, transid, time)
    SetExitTimeCommand.super.new(self);
    self._uuid = uuid;
    self._transid = transid;
    self._time =  time;
    self._prevtime = nil;
end

function SetExitTimeCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani and self._transid ~= nil then
        local native_transition = ani:GetTransitionById(0, self._transid);
        self._prevtime = native_transition.Conditions[1].ExitTime;
        native_transition.Conditions[1].ExitTime = self._time;
      end
    end
    self:EndCmd();
end

function SetExitTimeCommand:Undo()
    self:BeginCmd();
    if self._uuid then
        local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani and self._transid ~= nil then
        local native_transition = ani:GetTransitionById(0, self._transid);
        native_transition.Conditions[1].ExitTime = self._prevtime;
      end
    end
    self:EndCmd();
end

return SetExitTimeCommand;