local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local CreateStateCommand = CommandBase:extend("CreateStateCommand");

function CreateStateCommand:new(uuid)
    CreateStateCommand.super.new(self);
    self._uuid = uuid;
    self._stateUUID = ContentManager:GenerateUUID();
    self._state = nil;
end

function CreateStateCommand:DoIt()
    self:BeginCmd();
    local state = nil;
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani then
        state = ani:CreateState(0);
        state:SetStaticID(self._stateUUID);
        self._state = state;
      end
    end
    self:EndCmd();
end

function CreateStateCommand:Undo()
    self:BeginCmd();
    if self._state then
      local ani = self:GetContent(self._uuid);
      ani:RemoveState(0, self._state);
    end
    self:EndCmd();
end

return CreateStateCommand;