local libvenuscore = require "libvenuscore"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "window.editor.command.content_manager"
local ConditionPropertyChangeCommand = CommandBase:extend("ConditionPropertyChangeCommand");

function ConditionPropertyChangeCommand:new(uuid,  smsId, transId, conId, keyName, value)
    ConditionPropertyChangeCommand.super.new(self);
    self._uuid = uuid;
    self._smsId = smsId;
    self._transId = transId;
    self._conId = conId;
    self._keyName = keyName;
    self._value = value;
end

function ConditionPropertyChangeCommand:DoIt()
    if self._uuid then
        local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
        if com then
          local trans = com:GetTransitionById(self._smsId, self._transId);
          if trans then
              local con = trans:GetConditionById(self._conId);
              if con then
                self._preValue = con[self._keyName]; --之前值
                con[self._keyName] = self._value
              end
          end
          
        end
      end
 end

 function ConditionPropertyChangeCommand:Undo()
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        local trans = com:GetTransitionById(self._smsId, self._transId);
        if trans then
            local con = trans:GetConditionById(self._conId);
            if con then
                con[self._keyName] = self._preValue;
            end
        end
        
      end
    end
end

return ConditionPropertyChangeCommand;