local mathfunction = require "mathfunction"
local apollocore = require "apollocore"
local venuscore = require "libvenuscore"
local pnpestimates = require "pnpestimates"
local MemberIterator = require "venuscore.rtti.mpairs"
local RttiManager = require "venuscore.rtti.rttimanager"
local BundleSystem = require "venuscore.bundle.bundlesystem"
local PrefabTool = require "venuscore.bundle.serialization.prefabtool"
local libvenuscore = require "libvenuscore"
local BlueDeserialization = require "bluecore.bluedeserializaion"
local spinefunction = require "spinefunction"
local Deserialization = {};

Deserialization.version = 1;
local EditorSceneName = "Scene"
 
local NeedPause = _NeedPause;
--创建对象
function Deserialization:_InstantiationCls(typename, host, key)
  
  local cls = nil;
  if typename == "table" then
    --lua table 类型
    cls = {};
  elseif typename == venuscore.ScriptTypes.ReferenceTypeName then
    --如果是引用类型
    LOG("reference type");
  else
    --rtti manager创建对象
    if host ~= nil and BundleSystem.DeserializeInitDelegates[host:GetTypeName()] then
      cls = RttiManager:Newinstance(typename, host, BundleSystem.CurrentScene);
      if cls == nil then
        local func = BundleSystem.DeserializeInitDelegates[host:GetTypeName()];
        cls = func(host, typename, key);
      end
    else
      cls = RttiManager:Newinstance(typename, host, BundleSystem.CurrentScene);
    end
  end
  
  --facecute加载模式下，每创建一个对象Yield自己一次
  --给Update执行的机会
  if not _KRATOSEDITOR then
    if not NeedPause then
      NeedPause = _NeedPause;
    end
    NeedPause();
  end
  return cls;
end

function Deserialization:_Attributes(cls, attributes, nodes, referenceinfo)
  if attributes.__reference_uuid then
    referenceinfo.nodemap[attributes.__reference_uuid] = cls;
    if cls and cls.SetStaticID and BundleSystem.CurrentDeserializeMode == BundleSystem.DeserializeMode.Scene then
      --if attributes.__reference_uuid == "" then
      local staticID = attributes.__reference_uuid;
      local _beg,_end = string.find(attributes.__reference_uuid,"table: ");
      if _beg and _end then
        staticID = string.sub(attributes.__reference_uuid,_end + 1);
      end
      
      cls:SetStaticID(staticID);
      --cls:SetStaticID(attributes.__reference_uuid);
    end
    attributes.__reference_uuid = nil;
  end
  if cls and cls.GetTypeName then
    local typename = cls:GetTypeName();
    if BundleSystem.DeserializeDelegates[typename] then
      --自定义了实例化函数
      local func = BundleSystem.DeserializeDelegates[typename];
      func(cls, attributes, nodes);
      --table.insert(nodes,cls);  --实例化出的脚本node加入table中
      return cls;
    elseif type(cls) == "table" and cls:is(libvenuscore.Object) then
    --elseif type(cls) == "table" and cls:is(libvenuscore.VenusBehavior) then
      for name, attr in pairs(attributes) do
        cls:SetScriptValue(name,attr);
      end
      return cls;
    end
  end
  
  for name, attr in pairs(attributes) do
    cls[name] = attr;
  end
  
  
  
  return cls;  --再把cls返回回去
end




--收集类型信息，主要从类的注册属性中查找,table类型特殊处理，ChildNodes也是特例?
function Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo)
  local clsMembers = {};
  if cls ~= nil then
    if dataType == "table" or type(cls) == "table" then
      for key, value in pairs(attributes) do
        if key ~= "__typename" then
          if type(attributes[key]) == "table" then
            local keyNum = tonumber(key) or key;
            clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], host, cls[keyNum], keyNum, nodes, referenceinfo, cls);
          else
            clsMembers[key] = attributes[key];
          end
        end
      end
    else
      for key, handle in MemberIterator(cls) do
        if attributes[key] ~= nil then
          if type(attributes[key]) == "table" then
            clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
          else
            clsMembers[key] = attributes[key];
          end
        end
      end
    end
  end

  if attributes["__reference_uuid"] ~= nil then
    clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
  end
  return clsMembers;
end

BundleSystem:RegisterDeserialization("MorpherComponent",
        function(attributes, host, cls, key, nodes, referenceinfo)
          local dataType = attributes["__typename"];
          if cls == nil then
            cls = Deserialization:_InstantiationCls(dataType, host, key);
          end
          local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
          cls["Version"] = attributes["Version"]
          return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
        end
);


BundleSystem:RegisterDeserialization("Default",
        function(attributes, host, cls, key, nodes, referenceinfo)
          local dataType = attributes["__typename"];
          --LOG(dataType .. "deserialize!!");
          if cls == nil then
            cls = Deserialization:_InstantiationCls(dataType, host, key);
          end
          local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
          return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
        end
);

BundleSystem:RegisterDeserialization("BlueFtnLib", BlueDeserialization.onBlueFtnLib);
BundleSystem:RegisterDeserialization("BlueVariableInfo", BlueDeserialization.onBlueVariableInfo);
BundleSystem:RegisterDeserialization("BlueFunctionPinInfo", BlueDeserialization.onBlueFunctionInfo);
BundleSystem:RegisterDeserialization("BlueScene", BlueDeserialization.onBlueScene);
BundleSystem:RegisterDeserialization("BluePrint",BlueDeserialization.onBluePrint);
BundleSystem:RegisterDeserialization("BlueFunction",BlueDeserialization.onBlueFunction);
BundleSystem:RegisterDeserialization("BlueEventDispatcher",BlueDeserialization.onBlueEventDispatcher);
-- BlueNode派生类并且有名字
BundleSystem:RegisterDeserialization("BlueNode", BlueDeserialization.onBlueNode);
BundleSystem:RegisterDeserialization("BlueAnyTypeNode", BlueDeserialization.onBlueNode);
BundleSystem:RegisterDeserialization("BlueDynamicNode", BlueDeserialization.onBlueNode);
BundleSystem:RegisterDeserialization("BlueDynamicAnyTypePinsNode", BlueDeserialization.onBlueNode);
BundleSystem:RegisterDeserialization("BlueDynamicNoDesNode", BlueDeserialization.onBlueNode);
-- for compatibility
BundleSystem:RegisterDeserialization("IrisType", BlueDeserialization.OnBlueNil);
BundleSystem:RegisterDeserialization("Face106Type", BlueDeserialization.OnBlueNil);
BundleSystem:RegisterDeserialization("FaceAttributeType", BlueDeserialization.OnBlueNil);
BundleSystem:RegisterDeserialization("Advance134Type", BlueDeserialization.OnBlueNil);


BundleSystem:RegisterDeserialization(apollocore.RenderComponent:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
        end
);

BundleSystem:RegisterDeserialization(apollocore.Scene:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo,existscene)
          local dataType = attributes["__typename"];
          --蓝图重置的时候为了刷引用需要重新反序列化一个scene
          --导致scene会被换掉，所以编辑器模式下先判断下是否已经有了EitorScene
          if _KRATOSEDITOR then
            if existscene then
              cls = existscene;
            else
              cls = apollocore.SceneManager:CreateScene(EditorSceneName)
            end
          else
            --非编辑器模式下，Scene创建之后把根节点Deactive掉
            --并不是所有编辑器素材都把scene反序列化回来了（目前只处理了贴纸),所以需要区分
            if existscene then
              cls = existscene;
            else
              --要想办法把根节点删掉，否则老素材动画会有问题
              cls = apollocore.SceneManager:CreateScene(EditorSceneName)
              local rootNode = cls:GetRootNode();
              rootNode.Active = false;
            end
          end
          apollocore.SceneManager:SetReference(cls:GetStaticID(),referenceinfo);
          
          --local previewReferenceinfo = {};
          --previewReferenceinfo.nodemap = {};
          --previewReferenceinfo.callbacks = {};
          --local preview = nil;
          --编辑器模式下刷引用
          --if _KRATOSEDITOR then
          --  preview = apollocore.SceneManager:GetPreviewScene();
         
          --end
          
          
          --if preview then
          --  apollocore.SceneManager:SetReference(preview:GetStaticID(), previewReferenceinfo);--preview scene 的reference
          --  previewReferenceinfo.nodemap[attributes.__reference_uuid] = preview;
          --end
          
          local clsMembers = {};
          if cls ~= nil then
            for key, handle in MemberIterator(cls) do
              if attributes[key] ~= nil and key ~= "RootNode" then
                if type(attributes[key]) ~= "table" then
                  clsMembers[key] = attributes[key];
                elseif attributes[key]["__typename"] == "reference" then
                    clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
                    --if preview then
                      --clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], preview, preview[key], key, nodes, previewReferenceinfo, preview);
                    --end
                else
                    clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
                end
              end
            end
          end
          if attributes["__reference_uuid"] ~= nil then
            clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
          end
          
          return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
        end
);

--ParticleNode的序列化还借助PrticleNode实现
if apollocore.CPUEmitter ~= nil then
  BundleSystem:RegisterDeserialization(
    apollocore.CPUEmitter:GetTypeName(),
    function(attributes, host, cls, key, nodes, referenceinfo)
      local dataType = attributes["__typename"];
      if cls == nil then
        cls = host:CreateParticleNode():GetNativeNode();
      end
      return BundleSystem:GetDeserializationCallback(apollocore.Node:GetTypeName())(attributes, host, cls, key, nodes, referenceinfo);
    end
  );
end

if spinefunction.SpineNode ~= nil then
  BundleSystem:RegisterDeserialization(
    spinefunction.SpineNode:GetTypeName(),
    function(attributes, host, cls, key, nodes, referenceinfo)
      local dataType = attributes["__typename"];
      if cls == nil then
        cls = host:CreateSpineNode():GetNativeNode();
      end
      return BundleSystem:GetDeserializationCallback(apollocore.Node:GetTypeName())(attributes, host, cls, key, nodes, referenceinfo);
    end
  );
end


if apollocore.TextNode ~= nil then
BundleSystem:RegisterDeserialization(
  apollocore.TextNode:GetTypeName(),
  function(attributes, host, cls, key, nodes, referenceinfo)
    if attributes["Version"] == 2 then
      local dataType = attributes["__typename"];
      if cls == nil then
        cls = Deserialization:_InstantiationCls(dataType, host, key);
      end
	  if _KRATOSEDITOR then
        cls:SetSubNodeKey(tostring(key));
      end
      table.insert(nodes,1,cls);
      local clsMembers = {};
      local childNodes = {};
      if cls ~= nil then
        for key, handle in MemberIterator(cls) do
          if key ~= "ChildNodes" then
            if attributes[key] ~= nil then
              if type(attributes[key]) == "table" then
                clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(
                  attributes[key], cls, cls[key], key, nodes, referenceinfo, cls
                );
              else
                clsMembers[key] = attributes[key];
              end
            end
          end
        end
        for key, handle in MemberIterator(attributes["ChildNodes"]) do
          if key ~= "__typename" then
            childNodes[key] = BundleSystem:GetDeserializationCallback(handle["__typename"])(
              handle, host, nil, key, nodes, referenceinfo, cls
            );
          end
        end
      end
      clsMembers["ChildNodes"] = childNodes;
      if attributes["__reference_uuid"] ~= nil then
        clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
      end
      return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
    elseif attributes["Version"] == 1 then
      return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
    else
      return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
    end
  end
);
end

BundleSystem:RegisterDeserialization(apollocore.SDFTextNode:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          if attributes["Version"] == 2 then
            local dataType = attributes["__typename"];
            if cls == nil then
              cls = Deserialization:_InstantiationCls(dataType, host, key);
            end
            if _KRATOSEDITOR then
              cls:SetSubNodeKey(tostring(key));
            end
            table.insert(nodes,1,cls);
            local clsMembers = {};
            local childNodes = {};
            if cls ~= nil then
              for key, handle in MemberIterator(cls) do
                if key ~= "ChildNodes" then
                  if attributes[key] ~= nil then
                    if type(attributes[key]) == "table" then
                      clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(
                        attributes[key], cls, cls[key], key, nodes, referenceinfo, cls
                      );
                    else
                      clsMembers[key] = attributes[key];
                    end
                  end
                end
              end
              for key, handle in MemberIterator(attributes["ChildNodes"]) do
                if key ~= "__typename" then
                  childNodes[key] = BundleSystem:GetDeserializationCallback(handle["__typename"])(
                    handle, host, nil, key, nodes, referenceinfo, cls
                  );
                end
              end
            end
            clsMembers["ChildNodes"] = childNodes;
            if attributes["__reference_uuid"] ~= nil then
              clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
            end
            return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
          elseif attributes["Version"] == 1 then
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
          else
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
          end
        end
);

BundleSystem:RegisterDeserialization(apollocore.Node:GetTypeName(),
        function(attributes, host, cls, rootKey, nodes, referenceinfo)
          if attributes["Version"] == 2 then
            local dataType = attributes["__typename"];
            if cls == nil then
              cls = Deserialization:_InstantiationCls(dataType, host, key);
            end
            if _KRATOSEDITOR then
              cls:SetSubNodeKey(tostring(rootKey));
            end
            table.insert(nodes,1,cls);
            

            local clsMembers = {};
            local childNodes = {};
            if cls ~= nil then
              for key, handle in MemberIterator(cls) do
                if key ~= "ChildNodes" then
                  if attributes[key] ~= nil then
                    if type(attributes[key]) == "table" then
                      clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
                    else
                      clsMembers[key] = attributes[key];
                    end
                  end
                end
              end
              for key, handle in MemberIterator(attributes["ChildNodes"]) do
                if key ~= "__typename" then
                  childNodes[key] = BundleSystem:GetDeserializationCallback(handle["__typename"])(handle, host, nil, key, nodes, referenceinfo, cls);
                end
              end
            end
            clsMembers["ChildNodes"] = childNodes;
            if attributes["__reference_uuid"] ~= nil then
              clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
            end
            return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
          elseif attributes["Version"] == 1 then
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, rootKey, nodes, referenceinfo);
          else
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, rootKey, nodes, referenceinfo);
          end
        end
);

BundleSystem:RegisterDeserialization(apollocore.MaterialMetadata:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          if not attributes["Version"] or attributes["Version"] == 1 then  --旧版本材质
            local dataType = attributes["__typename"];
            if cls == nil then
              cls = Deserialization:_InstantiationCls(dataType, host, key);
            end
            local clsMembers = {};
            if cls ~= nil then
              for key, handle in pairs(attributes) do
                if key ~= "__typename" then
                  if type(attributes[key]) == "table" then
                    clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
                  else
                    clsMembers[key] = handle;  --这里可能会有问题(如果被删除的属性是一个C++对象，那这里就会有问题了)
                                               --按照版本兼容的原则，不需要的属性是不应该删掉的，但是材质这边都是完全删掉了
                                               --只能hack
                  end
                end
              end
            end
            if attributes["__reference_uuid"] ~= nil then
              clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
            end
            return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
          else
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
          end
        end
);

BundleSystem:RegisterDeserialization(apollocore.MaterialEntity:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          if not attributes["Version"] or attributes["Version"] == 1 then  --旧版本材质
            local dataType = attributes["__typename"];
            if cls == nil then
              cls = Deserialization:_InstantiationCls(dataType, host, key);
            end
            local clsMembers = {};
            if cls ~= nil then
              for key, handle in pairs(attributes) do
                if key ~= "__typename" then
                  clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
                  if key == "SourceMetadata" then
                    clsMembers["ShaderPath"] = handle[1]["ShaderPath"];
                  end
                end
              end
            end
            if attributes["__reference_uuid"] ~= nil then
              clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
            end
            return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
          else
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
          end
        end
);

BundleSystem:RegisterDeserialization(venuscore.ScriptTypes.ReferenceTypeName,
        function(attributes, host, cls, key, nodes, referenceinfo, parentCls)
          local refid = attributes.refid; --ref类型变为闭包，等待序列化完毕刷包
          local fieldName = attributes.fieldName;
          local fieldCount = attributes.fieldCount;
          local parentName = attributes.parentName;
          local num = attributes.number;
          local callback = {};
          callback.key = refid;
          callback.func = function(value)
            if venuscore.isNil(host) then
              return;
            end
            if type(parentCls) == "table" then
              parentCls[fieldName] = value;
              if table.getlength(parentCls) == fieldCount then
                host[parentName] = parentCls;
              end
            else
              if type(host[fieldName]) == "function" then
                host[fieldName](value);
              else
                host[fieldName] = value;
              end
            end
          end
          table.insert(referenceinfo.callbacks, callback);
          return nil;
        end
);

BundleSystem:RegisterDeserialization(apollocore.RenderObjectMeshMetadate:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          return nil;
        end
);

BundleSystem:RegisterDeserialization("PrefabNode",
        function(attributes, host, cls, key, nodes, referenceinfo)
          local diff = attributes.Diff;
          local prefabPath = attributes.PrefabPath;
          local diffInfo = PrefabTool:UnserializeTable(diff);
          local originPrefabInfo = PrefabTool:ReadPrefabInfo(prefabPath);
          if originPrefabInfo == nil then
            ERROR("failed to load prefab, create nothing");
            return nil;
          end
          local hash = apollocore.ContentManager:GenerateStaticID();
          BundleSystem.PrefabChangeIDMap[hash] = {};
          attributes = PrefabTool:PatchDiff(originPrefabInfo, diffInfo,
                  --prefab每次staticID会变化，记录一下对应关系，找引用
                  function(fieldName, oldID, newID)
                    if fieldName == "__reference_uuid" then
                      if not oldID or not newID then
                        return;
                      end
                      BundleSystem.PrefabChangeIDMap[hash][oldID] = newID;
                    end
                  end
          );
          BundleSystem.CurrentDeserializeMode = BundleSystem.DeserializeMode.Prefab;
          --通过场景反序列化得到的node也要标记成prefabnode，否则下次序列化将失去对prefab的引用，将全部数据序列化出去
          local result = BundleSystem:GetDeserializationCallback(attributes["__typename"])(attributes, host, cls, key, nodes, referenceinfo);
          --prefab反序列化完成后立即寻找引用，防止重复覆盖

          for i = #referenceinfo.callbacks, 1, -1 do
            local v = referenceinfo.callbacks[i]
            local obj = nil;
            if BundleSystem.PrefabChangeIDMap[hash][v.key] ~= nil then
              obj = referenceinfo.nodemap[BundleSystem.PrefabChangeIDMap[hash][v.key]];
              if obj then
                v.func(obj);
                table.remove(referenceinfo.callbacks,i)
              end
            else
              obj = referenceinfo.nodemap[v.key];
              if obj then
                v.func(obj);
                table.remove(referenceinfo.callbacks,i)
              end
            end
          end


          BundleSystem.PrefabChangeIDMap[hash] = {};
          BundleSystem.CurrentDeserializeMode = BundleSystem.DeserializeMode.Scene;
          return result;
        end
);

if pnpestimates.HeadTrackComponent then
  BundleSystem:RegisterDeserialization(
    pnpestimates.HeadTrackComponent:GetTypeName(),
    function(attributes, host, cls, key, nodes, referenceinfo)
      local dataType = attributes["__typename"];
      if cls == nil then
        cls = Deserialization:_InstantiationCls(dataType, host, key);
      end
      
      --兼容旧版本
      --因为新版本素材中已经将HeadTrackComponent的相机引用去掉了
      --所以这里直接将旧素材中的引用相机设置为Scene的主相机
      --这里的函数怎么调用到呢？
      cls["Camera"] = function(mainCamera)
        BundleSystem.CurrentScene:SetMainCamera(mainCamera);
      end
      
      local clsMembers = {};
      if cls ~= nil then
        for key, handle in pairs(attributes) do
          if key ~= "__typename" then
            if type(attributes[key]) == "table" then
              local aa = cls[key];
                clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(
                  attributes[key], cls, cls[key], key, nodes, referenceinfo, cls
                );
            else
              clsMembers[key] = handle;
            end
          end
        end
      end
      if attributes["__reference_uuid"] ~= nil then
        clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
      end
      return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
    end
  );
end

if apollocore.ParticleComponent then
  BundleSystem:RegisterDeserialization(
    apollocore.ParticleComponent:GetTypeName(),
    function(attributes, host, cls, key, nodes, referenceinfo)
      local dataType = attributes["__typename"];
      if cls == nil then
        cls = host:CreateComponent(apollocore.Node.CT_PARTICLE);
        local renderType = attributes["ModeType"];
        local evolvers = attributes["ParticleEvolvers"];
        for k,v in pairs(evolvers) do
          if type(k) == 'number' then
            cls:AddEvolver(k)
          end
        end
      end
      if not attributes["PaticleVersion"] then
        cls["PaticleVersion"] = 1;
      end
      local res = BundleSystem:GetDeserializationCallback("Default")(
        attributes, host, cls, key, nodes, referenceinfo
      );
      cls:CreateResource();
      return res;
    end
  );
end

if apollocore.ParticleEmitter ~= nil then
  BundleSystem:RegisterDeserialization(
    apollocore.ParticleEmitter:GetTypeName(),
    function(attributes, host, cls, key, nodes, referenceinfo)
      local dataType = attributes["__typename"];
      --LOG(dataType .. "deserialize!!");
      local shapeType = attributes["EmitterShapeType"];
      cls.EmitterShapeType = shapeType;
      
      local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
      return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
    end
  );
end

if apollocore.ParticleDistribution then
  BundleSystem:RegisterSerialization(
    apollocore.ParticleDistribution:GetTypeName(),
    function(obj, rootkey)
      local cls = {};
      cls["typename"] = apollocore.ParticleDistribution:GetTypeName();
      cls["__reference_uuid"] = obj.GetStaticID and obj:GetStaticID() or nil;
      cls["fieldname"] = rootkey or "";
      cls["members"] = {};
      BundleSystem:_SerializeTraverseNode(obj["Type"],obj,"Type",cls["members"]);
      BundleSystem:_SerializeTraverseNode(obj["Version"],obj,"Version",cls["members"]);
      BundleSystem:_SerializeTraverseNode(obj["MaxValue"],obj,"MaxValue",cls["members"]);
      BundleSystem:_SerializeTraverseNode(obj["MinValue"],obj,"MinValue",cls["members"]);
    
      if obj.Type == apollocore.ParticleDistribution.PDT_CONSTANT then
        BundleSystem:_SerializeTraverseNode(obj["ConstMinValue"],obj,"ConstMinValue",cls["members"]);
      elseif obj.Type == apollocore.ParticleDistribution.PDT_RANDOM_RANGE then
        BundleSystem:_SerializeTraverseNode(obj["ConstMinValue"],obj,"ConstMinValue",cls["members"]);
        BundleSystem:_SerializeTraverseNode(obj["ConstMaxValue"],obj,"ConstMaxValue",cls["members"]);
      elseif obj.Type == apollocore.ParticleDistribution.PDT_CURVE then
        BundleSystem:_SerializeTraverseNode(obj["MinCurve"],obj,"MinCurve",cls["members"]);
      else
        BundleSystem:_SerializeTraverseNode(obj["MinCurve"],obj,"MinCurve",cls["members"]);
        BundleSystem:_SerializeTraverseNode(obj["MaxCurve"],obj,"MaxCurve",cls["members"]);
      end
      
      return cls;
    end
  )
end

if apollocore.ColorDistribution then
  BundleSystem:RegisterSerialization(apollocore.ColorDistribution:GetTypeName(),
    function(obj, rootkey)
      local cls = {};
      cls["typename"] = apollocore.ColorDistribution:GetTypeName();
      cls["__reference_uuid"] = obj.GetStaticID and obj:GetStaticID() or nil;
      cls["fieldname"] = rootkey or "";
      cls["members"] = {};
      
      BundleSystem:_SerializeTraverseNode(obj["Type"],obj,"Type",cls["members"]);
      BundleSystem:_SerializeTraverseNode(obj["Version"],obj,"Version",cls["members"]);
      if obj.Type == apollocore.ColorDistribution.PDT_CONSTANT then
        BundleSystem:_SerializeTraverseNode(obj["ConstMinValue"],obj,"ConstMinValue",cls["members"]);
      elseif obj.Type == apollocore.ColorDistribution.PDT_RANDOM_RANGE then
        BundleSystem:_SerializeTraverseNode(obj["ConstMinValue"],obj,"ConstMinValue",cls["members"]);
        BundleSystem:_SerializeTraverseNode(obj["ConstMaxValue"],obj,"ConstMaxValue",cls["members"]);
      elseif obj.Type == apollocore.ColorDistribution.PDT_CURVE then
        BundleSystem:_SerializeTraverseNode(obj["MinGradient"],obj,"MinGradient",cls["members"]);
        BundleSystem:_SerializeTraverseNode(obj["MinAlphaCurve"],obj,"MinAlphaCurve",cls["members"]);
      else
        BundleSystem:_SerializeTraverseNode(obj["MinGradient"],obj,"MinGradient",cls["members"]);
        BundleSystem:_SerializeTraverseNode(obj["MinAlphaCurve"],obj,"MinAlphaCurve",cls["members"]);
        
        BundleSystem:_SerializeTraverseNode(obj["MaxGradient"],obj,"MaxGradient",cls["members"]);
        BundleSystem:_SerializeTraverseNode(obj["MaxAlphaCurve"],obj,"MaxAlphaCurve",cls["members"]);
      end
      return cls;
    end
  )
end

if apollocore.ParticleDistribution then
  BundleSystem:RegisterDeserialization(
    apollocore.ParticleDistribution:GetTypeName(),
    function(attributes, host, cls, key, nodes, referenceinfo)
      if not attributes["Version"] then
        if cls == nil then
          local dataType = attributes["__typename"];
          cls = Deserialization:_InstantiationCls(dataType, host, key);
        end
        cls["Type"] = attributes["Type"];
        cls["MinValue"] = attributes["MinValue"];
        cls["MaxValue"] = attributes["MaxValue"];
        
        if attributes["Type"] == apollocore.ParticleDistribution.PDT_CONSTANT then
          cls["ConstMinValue"] = attributes["ConstMinValue"];
        elseif attributes["Type"] == apollocore.ParticleDistribution.PDT_RANDOM_RANGE then
          cls["ConstMinValue"] = attributes["ConstMinValue"];
          cls["ConstMaxValue"] = attributes["ConstMaxValue"];
        elseif attributes["Type"] == apollocore.ParticleDistribution.PDT_CURVE then
          local dataType = attributes["MinCurve"]["__typename"];
          local clsMembers = Deserialization:_CollectAttributes(
            attributes["MinCurve"], dataType, cls["MinCurve"], host, nodes, referenceinfo
          );
          Deserialization:_Attributes(cls["MinCurve"], clsMembers, nodes, referenceinfo);
        else
          local dataType = attributes["MinCurve"]["__typename"];
          local clsMembers = Deserialization:_CollectAttributes(
            attributes["MinCurve"], dataType, cls["MinCurve"], host, nodes, referenceinfo
          );
          Deserialization:_Attributes(cls["MinCurve"], clsMembers, nodes, referenceinfo);
          
          clsMembers = Deserialization:_CollectAttributes(
            attributes["MaxCurve"], dataType, cls["MaxCurve"], host, nodes, referenceinfo
          );
          Deserialization:_Attributes(cls["MaxCurve"], clsMembers, nodes, referenceinfo);
        end
        return cls;
      else
        return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
      end
    end
  );
end

if apollocore.ColorDistribution then
  BundleSystem:RegisterDeserialization(
    apollocore.ColorDistribution:GetTypeName(),
    function(attributes, host, cls, key, nodes, referenceinfo)
      if not attributes["Version"] then
        if cls == nil then
          local dataType = attributes["__typename"];
          cls = Deserialization:_InstantiationCls(dataType, host, key);
        end
        cls["Type"] = attributes["Type"];
        if attributes["Type"] == apollocore.ColorDistribution.PDT_CONSTANT then
          local dataType = attributes["ConstMinValue"]["__typename"];
          local clsMembers = Deserialization:_CollectAttributes(
            attributes["ConstMinValue"], dataType, cls["ConstMinValue"], host, nodes, referenceinfo
          );
          cls["ConstMinValue"] = Deserialization:_Attributes(cls["ConstMinValue"], clsMembers, nodes, referenceinfo);
        elseif attributes["Type"] == apollocore.ColorDistribution.PDT_RANDOM_RANGE then
          local dataType = attributes["ConstMinValue"]["__typename"];
          local clsMembers = Deserialization:_CollectAttributes(
            attributes["ConstMinValue"], dataType, cls["ConstMinValue"], host, nodes, referenceinfo
          );
          cls["ConstMinValue"] = Deserialization:_Attributes(cls["ConstMinValue"], clsMembers, nodes, referenceinfo);
        
          clsMembers = Deserialization:_CollectAttributes(
            attributes["ConstMaxValue"], dataType, cls["ConstMaxValue"], host, nodes, referenceinfo
          );
          cls["ConstMaxValue"] = Deserialization:_Attributes(cls["ConstMaxValue"], clsMembers, nodes, referenceinfo);
        elseif attributes["Type"] == apollocore.ColorDistribution.PDT_CURVE then
          local dataType = attributes["MinGradient"]["__typename"];
          local clsMembers = Deserialization:_CollectAttributes(
            attributes["MinGradient"], dataType, cls["MinGradient"], host, nodes, referenceinfo
          );
          Deserialization:_Attributes(cls["MinGradient"], clsMembers, nodes, referenceinfo);
          
          dataType = attributes["MinAlphaCurve"]["__typename"];
          clsMembers = Deserialization:_CollectAttributes(
            attributes["MinAlphaCurve"], dataType, cls["MinAlphaCurve"], host, nodes, referenceinfo
          );
          Deserialization:_Attributes(cls["MinAlphaCurve"], clsMembers, nodes, referenceinfo);
        else
          local dataType = attributes["MinGradient"]["__typename"];
          local clsMembers = Deserialization:_CollectAttributes(
            attributes["MinGradient"], dataType, cls["MinGradient"], host, nodes, referenceinfo
          );
          Deserialization:_Attributes(cls["MinGradient"], clsMembers, nodes, referenceinfo);
          clsMembers = Deserialization:_CollectAttributes(
            attributes["MaxGradient"], dataType, cls["MaxGradient"], host, nodes, referenceinfo
          );
          Deserialization:_Attributes(cls["MaxGradient"], clsMembers, nodes, referenceinfo);
          
          dataType = attributes["MinAlphaCurve"]["__typename"];
          clsMembers = Deserialization:_CollectAttributes(
            attributes["MinAlphaCurve"], dataType, cls["MinAlphaCurve"], host, nodes, referenceinfo
          );
          Deserialization:_Attributes(cls["MinAlphaCurve"], clsMembers, nodes, referenceinfo);
          clsMembers = Deserialization:_CollectAttributes(
            attributes["MaxAlphaCurve"], dataType, cls["MaxAlphaCurve"], host, nodes, referenceinfo
          );
          Deserialization:_Attributes(cls["MaxAlphaCurve"], clsMembers, nodes, referenceinfo);
        end
        return cls;
      else
        return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
      end
    end
  );
end

return Deserialization;
