local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local TwoMirror = {}
TwoMirror.TM = 0;

TwoMirror.Queue = 116;

function TwoMirror:Initialize(host, size)
  self.TM = host:CreateRenderObject("comm:documents/filter/material/twomirror.material");
  return self.Queue;
end

function TwoMirror:Resizeview(size)
end

function TwoMirror:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.TM:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.TM:Draw(pipeline);
end

return TwoMirror;

