local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local soulhit = {}
soulhit.Sh = 0;
soulhit.Queue = 119;



function soulhit:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.COUNT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"COUNT"); 
  self.AMPLIFY_SCALE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"AMPLIFY_SCALE"); 
  self.Sh = host:CreateRenderObject("comm:documents/filter/material/soulhit.material" );
  self.Sh:SetParameter(self.COUNT, mathfunction.vector1( 0.0 ) );    --计数变量，增速控制特效的变化速度
  self.Sh:SetParameter(self.AMPLIFY_SCALE, mathfunction.vector1( 10.0 ) );  -- 控制特效大小
  return self.Queue;
end

function soulhit:Resizeview(size)
  --self:_SetParam(size);
end

function soulhit:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Sh:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Sh:Draw(pipeline);
end

return soulhit;