local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local siximg = {}
siximg.Si = 0;

siximg.Queue = 201;



function siximg:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.RATIOASPECT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"RATIOASPECT");
  self.Si = host:CreateRenderObject("comm:documents/filter/material/siximg.material" );
  self.Si:SetParameter(self.RATIOASPECT, mathfunction.vector1(size:y()/size:x()) );
  
  return self.Queue;
end

function siximg:Resizeview(size)
  self:_SetParam(size);
end

function siximg:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Si:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Si:Draw(pipeline);
end

return siximg;