local BlueFunctionNode = require "bluecore.functioncore.blue_func_node"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local FunctionOutputNode = BlueFunctionNode:extend(); 

---- 游戏运行模式
function FunctionOutputNode:new(...)  --这里的graph是bluefunction
  FunctionOutputNode.super.new(self, ...)

  -- 保留原来有的输出和输入执行引脚信息(可以为nil)
  local originExecInputsInfo = self.infoTable[BD.PIN_EXEC_INPUT]
  
  self.infoTable = {} -- 重新定义infoTable 元表的infoTable不变
  self.infoTable[BD.PIN_DATA_INPUT] = {}
  self.infoTable[BD.PIN_DATA_OUTPUT] = {}
  self.infoTable[BD.PIN_EXEC_INPUT]  = originExecInputsInfo
  self.infoTable[BD.PIN_EXEC_OUTPUT] = {}

end

function FunctionOutputNode:_OnCreateWithEditor()
  self.graph:AddRefactor(self);
end


function FunctionOutputNode:_OnInfoChange(reflectIdx, type, val, isInput)
  if isInput == true then
    return ;
  end

  local curInfo = self.infoTable[BD.PIN_DATA_INPUT][reflectIdx]

  if type == BD.FuncInfoProp.Name then
    curInfo.name = val;
  elseif type == BD.FuncInfoProp.BaseType then
    curInfo:ChangeRtti(val, BU:GetDefaultByRtti(val));
    self.inputs[reflectIdx].literal = BU:GenerateLiteral(val, curInfo:GetDefault());
    -- 立刻更新字面值 避免崩溃
  elseif type == BD.FuncInfoProp.Value then
    curInfo:ChangeDefault(val);
    self.inputs[reflectIdx].literal = val
    -- 参数默认值修改 节点的字面值不管是否修改过 都同步一致
  end
end

function FunctionOutputNode:_OnEditorPinDelete(isInput, idx)

  if isInput then return end ;

  local toDelInsPin = self.inputs[idx];
  self.graph:DeleteNodePin(toDelInsPin.uid);
  self:RemoveInput(idx);

end

function FunctionOutputNode:_OnEditorPinAdd(isInput, reflectInfo)

  if isInput then return end ;

  local toAddInsPin = self:AddInput(reflectInfo);
  self.graph:AddBlueNodePinToAll(toAddInsPin);

end

--[[function FunctionOutputNode:_OnCompile()
  
  --不能放这边  没有连线则不会执行
  self.outputResults = {};
  for _,input in pairs(self.inputs) do
    table.insert(self.outputResults, input.literal);
  end
  return true;

end]]--

function FunctionOutputNode:_OnUpdate(args)
  return args --实际没有输出引脚 但拿到值的时候只需要索引和节点
end


function FunctionOutputNode:_OnDeserializePost()

  FunctionOutputNode.super:_OnDeserializePost()
  --反序列化会调用new函数 不用重新声明infotable
  local newArgId = 1
  local reflectOutputsInfo = self.graph:GetOutputInfo();
  for key, reflectInfo in pairs(reflectOutputsInfo) do
    self:DynamicRegisterInput(newArgId, reflectInfo:GetRtti(), reflectInfo.name, reflectInfo.tips);
    newArgId = newArgId + 1;
  end

  self.graph:AddRefactor(self);

end


--不允许克隆与删除
function FunctionOutputNode:IsAllowDuplicate()
  return false;
end

function FunctionOutputNode:IsAllowDelete()
  return false;
end

function FunctionOutputNode:ToBeDeletedEd()
  -- 所在函数要被删除(编辑器)
end

function FunctionOutputNode:NameChanged(oldName, newName)

end

FunctionOutputNode:RegisterExecInput(1, "exec", "Execute");
FunctionOutputNode:SetFunctionName("Output");
FunctionOutputNode:SetFunctionType(BD.FUNCTION_INTERFACE_NODE);

return FunctionOutputNode ;

