local BluePinInfo = require "bluecore.bluepininfo"
local BlueNode = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"

local BlueFunctionNode = BlueNode:extend(); 

---- 游戏运行模式
function BlueFunctionNode:new(graph)
  BlueFunctionNode.super.new(self, graph)
end


-- Override
function BlueFunctionNode:Update(execIdx)

  -- check whether this node take as input
  if execIdx == nil and self:_SkipUpdateAsInput() then
    return
  end

  -- get inputs
  local args = self:_GetInput();

  -- debug point
  if _KRATOSEDITOR then
    local BuEd = require "bluecore.editor.blueutility_ed"
    BuEd:BlueDebugYield(self);
  end

  -- execute and get results
  self.outputResults = self:_OnUpdate(args) or {} -- OnUpdate return {} directly, NO unpack

  return 1
end

function BlueFunctionNode:AddOutput(reflectInfo)

  local newArgId = 1
  for _ , __ in pairs(self.infoTable[BD.PIN_DATA_OUTPUT]) do
    newArgId = newArgId + 1
  end

  local pinInfo = self:DynamicRegisterOutput(newArgId, reflectInfo:GetRtti(), reflectInfo:GetName(), reflectInfo:GetTips());
  -- Step 2 增加 BluePrintPin :连接和字面值信息
  local outputPin = {
    uid     = self.graph and self.graph:_NextID() or -1,
    nodeUid = self.uid,
    pinType = BD.PIN_DATA_OUTPUT,
    argId   = pinInfo.argId,
    links   = {},
    --useLiteral = true ,
    --literal = BU:GenerateLiteral(pinInfo.rtti, pinInfo.default),
    delAble = false
  }
  table.insert(self.outputs, outputPin); -- 会序列化

  --不涉及特化 不加入组

  return outputPin;
  -- body
end

function BlueFunctionNode:RemoveOutput(rmIdx)

  -- Step 1 删除引脚信息
  local tobeDeletedInfo = self.infoTable[BD.PIN_DATA_OUTPUT][rmIdx]
  local iremap = self:_DynamicDeregisterInfo(tobeDeletedInfo, BD.PIN_DATA_OUTPUT);

  -- Step 2 不涉及特化 
  --self:ExitGroup(BlueAnyTypeNode.DEFAULT_GROUP, outputPin.uid);

  -- Step 3 重建outputs
  local oldOutputs = self.outputs
  self.outputs  = {}
  for _, info in ipairs(self.infoTable[BD.PIN_DATA_OUTPUT]) do
    local pin = oldOutputs[iremap[info.argId]]
    pin.argId = info.argId;
    table.insert( self.outputs, pin)
  end

end

function BlueFunctionNode:AddInput(reflectInfo)

  local newArgId = 1
  for _ , __ in pairs(self.infoTable[BD.PIN_DATA_INPUT]) do
    newArgId = newArgId + 1
  end

  -- default 直接按照字面值的生成方法
  -- 避免Node/BlueprintType类型(引用)作为函数参数
  -- 创建调用节点引脚默认值和字面值会直接引用Node/Actor
  local rtti = reflectInfo:GetRtti()
  local defaultValue
  if rtti:isArray() then
    defaultValue = {}
  else
    defaultValue = BU:GenerateLiteral(rtti, reflectInfo:GetDefault());
  end

  local pinInfo = self:DynamicRegisterInput(newArgId, reflectInfo:GetRtti(), reflectInfo:GetName(), reflectInfo:GetTips(), defaultValue );

  local inputPin = {
    uid     = self.graph and self.graph:_NextID() or -1,
    nodeUid = self.uid,
    pinType = BD.PIN_DATA_INPUT,
    argId   = pinInfo.argId,
    links   = {},
    useLiteral = true ,
    literal = defaultValue,
    delAble = false
  }
  table.insert(self.inputs, inputPin); -- 会序列化

  --不涉及特化 不加入组
  return inputPin;
end

function BlueFunctionNode:RemoveInput(rmIdx)

  -- Step 1 删除引脚信息
  local tobeDeletedInfo = self.infoTable[BD.PIN_DATA_INPUT][rmIdx]
  local iremap = self:_DynamicDeregisterInfo(tobeDeletedInfo, BD.PIN_DATA_INPUT);

  -- Step 2 不涉及特化 
  --self:ExitGroup(BlueAnyTypeNode.DEFAULT_GROUP, outputPin.uid);

  -- Step 3 重建inputs
  local oldInputs = self.inputs
  self.inputs  = {}
  for _, info in ipairs(self.infoTable[BD.PIN_DATA_INPUT]) do
    local pin = oldInputs[iremap[info.argId]]
    pin.argId = info.argId;
    table.insert(self.inputs, pin)
  end

end


function BlueFunctionNode:DynamicRegisterInput(argId, rtti, name, tips, default, delAble, groupName)

  if tips == nil then tips = "["..tostring(argId).."]" end
  if name == nil then name = "["..tostring(argId).."]" end

  local info = BluePinInfo(BD.PIN_DATA_INPUT, argId, rtti, name, tips, default, delAble, groupName);
  self.infoTable[BD.PIN_DATA_INPUT][argId] = info -- 提供给外部访问pin的info && BlueNode底层需要

  return info ;  -- 返回info 用来新增pin

end

function BlueFunctionNode:DynamicRegisterOutput(argId, rtti,  name, tips, default, delAble, groupName)

  if tips == nil then tips = "out:"..tostring(argId)  end
  if name == nil then name = tostring(argId)  end

  local info =  BluePinInfo(BD.PIN_DATA_OUTPUT, argId, rtti,  name, tips, default, delAble, groupName);
  self.infoTable[BD.PIN_DATA_OUTPUT][argId] = info

  return info;
end


function BlueFunctionNode:_DynamicDeregisterInfo(pinInfo, direct)

    local argId = pinInfo.argId ;
    self.infoTable[direct][argId] = nil

    local iremap= {} -- 新->旧
    local new_index = 1
    for index, _ in pairs(self.infoTable[direct]) do
      iremap[new_index] = index
      new_index = new_index + 1
    end

    for index = 1, new_index-1 do
      self.infoTable[direct][index] = self.infoTable[direct][iremap[index]]
      self.infoTable[direct][index].argId = index
    end

    -- 移走最后一个
    table.remove(self.infoTable[direct], new_index)
    return iremap -- 返回映射表 用来更新pin
end

function BlueFunctionNode:EditorPinAdd(isInput, funcInfo) -- funcInfo or BlueFunction
  self:_OnEditorPinAdd(isInput, funcInfo);
end

function BlueFunctionNode:_OnEditorPinAdd(isInput, funcInfo)

end

function BlueFunctionNode:InfoChange(argIdx, type, val, isInput)
  self:_OnInfoChange(argIdx, type, val, isInput);
end

function BlueFunctionNode:_OnInfoChange(argIdx, type, val, isInput)

end

function BlueFunctionNode:EditorPinDelete(isInput, argIdx)
  self:_OnEditorPinDelete(isInput, argIdx);
end

function BlueFunctionNode:_OnEditorPinDelete(isInput, argIdx)

end

return BlueFunctionNode ;

