local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local BlueNode = require "bluecore.bluenode"
local BluePinInfo = require "bluecore.bluepininfo"
local Types = require "venuscore.rtti.types"
local mf = require "mathfunction"
local BFPI = require "bluecore.bluefuncpininfo"
local BlueRtti = require "bluecore.core.blue_rtti"

local CustomEventNode = BlueNode:extend();

function CustomEventNode:new(...)
  CustomEventNode.super.new(self, ...)
  self._RefactorList = setmetatable({}, { __mode = 'v' })
end

function CustomEventNode:_OnBeginCreateEd(eventName)

  self._inputInfoArray = {}; -- 反射面板显示的是输入参数 事件节点的是输出引脚

  self:_SetupDelegateType();

  local execOutputInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]
  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}             --  没有输入引脚
  self.infoTable[BD.PIN_DATA_OUTPUT] = {}             -- 第一个应该是委托引脚
  self.infoTable[BD.PIN_EXEC_INPUT]  = {}              -- 没有执行输入
  self.infoTable[BD.PIN_EXEC_OUTPUT] = execOutputInfo  -- 只有一个执行输出

  self.infoTable[BD.PIN_DATA_OUTPUT][1] =
  BluePinInfo(BD.PIN_DATA_INPUT, 1, self._eventDelegateType, "delegate", "", nil, false, nil);

  self.nodeName = eventName ; -- 显示的名字
  self._eventName = BD.EVENT_PREFIX..tostring(self:GetUid()) -- 实际生成函数的名字

end

function CustomEventNode:_OnCreateWithEditor()
  -- 新建,在自己new构造过程中注册;删除,在节点_OnDeleteEd中反注册
  -- 反序列化,由blueprint统一注册
  BlueRtti.AppendCustomEventToClassInfoEd(self.graph, self);

  self._CreatedDone = true ;

end

-- 事件代理类型 -- 实际就是参数的签名信息
-- 自定义事件节点 和 事件分发器的 签名信息 (参数按顺序类型和个数一样 EventDelegateType:isType)
function CustomEventNode:_SetupDelegateType()
  local newType = Types.EventDelegateType:extend()
  newType:SetArgsInfo(self._inputInfoArray) -- 直接引用_inputInfoList
  self._eventDelegateType = newType         -- 需要加入classMap
end

function CustomEventNode:_OnDeserialize()

  CustomEventNode.super:_OnDeserialize()

  local execOutputInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]
  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}
  self.infoTable[BD.PIN_DATA_OUTPUT] = {}
  self.infoTable[BD.PIN_EXEC_INPUT]  = {}
  self.infoTable[BD.PIN_EXEC_OUTPUT] = execOutputInfo

  self:_SetupDelegateType();

  self.infoTable[BD.PIN_DATA_OUTPUT][1] =
  BluePinInfo(BD.PIN_DATA_INPUT, 1, self._eventDelegateType, "delegate", "", nil, false, nil);

  -- BlueFunctionPinInfo -> BluePinInfo
  local newArgId = 2;
  for _, blueFuncPinInfo in pairs(self._inputInfoArray) do
    self:_DynamicRegisterOutput(newArgId, blueFuncPinInfo:GetRtti(), blueFuncPinInfo:GetName(), blueFuncPinInfo:GetTips());
    newArgId = newArgId + 1;
    blueFuncPinInfo:SetOwner(self);
  end


  self._eventName = BD.EVENT_PREFIX..tostring(self:GetUid())
  -- self.nodeName是可改变的 反序列化恢复的

  self.graph:AppendCustomEventNode(self);
  -- _DeleteCustomEventNodeEd

  self._CreatedDone = true
end


function CustomEventNode:_DynamicRegisterOutput(argId, rtti, name, tips, default, delAble, groupName)

  if tips == nil then tips = "out:"..tostring(argId)  end
  if name == nil then name = tostring(argId)  end

  local info =  BluePinInfo(BD.PIN_DATA_OUTPUT, argId, rtti, name, tips, default, delAble, groupName);
  self.infoTable[BD.PIN_DATA_OUTPUT][argId] = info

  return info;
end

function CustomEventNode:_DynamicDeregisterInfo(pinInfo, direct)

  local argId = pinInfo.argId ;
  self.infoTable[direct][argId] = nil

  local iremap= {}
  local newIndex = 1
  for index, _ in pairs(self.infoTable[direct]) do
    iremap[newIndex] = index
    newIndex = newIndex + 1
  end

  for index = 1, newIndex -1 do
    self.infoTable[direct][index] = self.infoTable[direct][iremap[index]]
    self.infoTable[direct][index].argId = index
  end

  table.remove(self.infoTable[direct], newIndex)
  return iremap
end


-- 增加infoTable 并且 增加pin
function CustomEventNode:AddArgumentEd()

  -- blueFuncPinInfo not include arguments order id
  local newArgId = 1
  for _ , __ in pairs(self.infoTable[BD.PIN_DATA_OUTPUT]) do
    newArgId = newArgId + 1
  end

  local pinName = "New Param "..tostring(newArgId - 1)

  local pinInfo = self:_DynamicRegisterOutput(newArgId, mf.vector3:RTTI(), pinName, nil);

  local outputPin = {
    uid     = self.graph and self.graph:_NextID() or -1,
    nodeUid = self.uid,
    pinType = BD.PIN_DATA_OUTPUT,
    argId   = pinInfo.argId,
    links   = {},
    useLiteral = nil,
    literal = nil,
    delAble = false
  }
  table.insert(self.outputs, outputPin);

  self.graph:AddBlueNodePinToAll(outputPin);

  local reflectInfo = BFPI(mf.vector3:GetTypeName(), false);
  reflectInfo:EditorCreate(true, pinName, "No Tips", self.graph:_NextID());
  reflectInfo:SetOwner(self);
  table.insert(self._inputInfoArray, reflectInfo)

  -- 目前只有 EventInfo 注册到 self._RefactorList
  for _, refactor in pairs(self._RefactorList) do
    refactor:EditorPinAdd(true, reflectInfo)
  end

  return outputPin.uid ;
end


function CustomEventNode:RemoveArgumentEd(arrayIndex)

  local argId = arrayIndex + 1 -- _inputInfoArray的序号 不包含第一个输出引脚(委托)
  WARNING("RemoveArgumentEd "..tostring(argId))

  -- delete pin
  local toDelInsPin = self.outputs[argId];
  self.graph:DeleteNodePin(toDelInsPin.uid);

  -- delete bluePinInfo from infoTable and reorder infoTable
  local tobeDeletedInfo = self.infoTable[BD.PIN_DATA_OUTPUT][argId]
  local iremap = self:_DynamicDeregisterInfo(tobeDeletedInfo, BD.PIN_DATA_OUTPUT);

  -- re-order outputs
  local oldOutputs = self.outputs
  self.outputs = {}
  for _, info in ipairs(self.infoTable[BD.PIN_DATA_OUTPUT]) do
    local pin = oldOutputs[iremap[info.argId]]
    pin.argId = info.argId;
    table.insert(self.outputs, pin)
  end

  -- remove from de/serialize-list
  table.remove(self._inputInfoArray, arrayIndex);

  -- TODO 从EventInfo移除   EventInfo再回调 事件调用节点 增删
  for _, refactor in pairs(self._RefactorList) do -- 目前只有 EventInfo 注册到这里
    refactor:EditorPinDelete(true, arrayIndex)
  end
end


-- EventDispatcher
-- EventInfo
-- isInput: 只有true
function CustomEventNode:ChangeInfo(blueFuncPinInfo, type, val, isInput)

  -- blueFuncPinInfo is one of array 'self._inputInfoArray'

  -- 反射面板已经修改 'blueFuncPinInfo' 然后才调用到这里通知  参考BlueFunction:ChangeInfo
  local arrayIndex = nil
  for idx, info in pairs(self._inputInfoArray) do
    if info == blueFuncPinInfo then
      arrayIndex = idx
      break
    end
  end

  if arrayIndex == nil then error("CustomEventNode ChangeInfo no arrayIndex"); end


  -- 修改当前节点的引脚
  local argId = arrayIndex + 1

  local curInfo = self.infoTable[BD.PIN_DATA_OUTPUT][argId]
  local pin = self.outputs
  pin = pin[argId]

  if type == BD.FuncInfoProp.Name then
    curInfo.name = val;
  elseif type == BD.FuncInfoProp.BaseType then
    curInfo:ChangeRtti(val, BU:GetDefaultByRtti(val));
  elseif type == BD.FuncInfoProp.Value then
    --curInfo:ChangeDefault(val);  -- 输出引脚 不用设置默认值
  end

  -- 同步 EventInfo (对于调用节点来说是输入引脚修改了)
  -- 对于蓝图类来说 只有一个场景的custom_event_node会对应classInfo中的eventInfo, eventInfo会对应两个场景的调用函数节点
  for _, refactor in pairs(self._RefactorList) do
    refactor:InfoChange(arrayIndex, type, val, true); --
  end

end


-- interface IInfoChange
--          InfoChange
--          EditorPinDelete
--          EditorPinAdd
function CustomEventNode:AddRefactor(iInfoChange)
  if not iInfoChange.InfoChange      then error("CustomEventNode missing InfoChange "); end
  if not iInfoChange.EditorPinDelete then error("CustomEventNode missing EditorPinDelete "); end
  if not iInfoChange.EditorPinAdd    then error("CustomEventNode missing EditorPinAdd "); end
  table.insert(self._RefactorList, iInfoChange)
end

function CustomEventNode:RemoveRefactor(iInfoChange)
  if _KRATOSEDITOR then
    for idx, cb in pairs(self._RefactorList) do
      if cb == iInfoChange then
        self._RefactorList[idx] = nil
      end
    end
  end
end


function CustomEventNode:_OnUpdate(args)
  -- BindEventDispatcher do NOT call update for eventdelegate pin
  return self, unpack(args) -- 委托引脚,输出自身, args其他数据输出引脚
end

function CustomEventNode:GetInputInfo()
  return self._inputInfoArray ;
end

function CustomEventNode:GetEventName()
  return self._eventName
end

--not allow to duplicate
function CustomEventNode:IsAllowDuplicate()
  return false;
end

function CustomEventNode:_OnDeleteEd()

  -- 通知eventInfo要删除(从classInfo上删除eventInfo)
  for _, eventInfo in pairs(self._RefactorList) do
    eventInfo:ToBeDeletedEd()
  end

  -- 从所属的blueprint的自定义事件列表移除  -- AppendCustomEventNode
  self.graph:_DeleteCustomEventNodeEd(self:GetUid());
end

function CustomEventNode:_GetName()
  return self.nodeName
end

function CustomEventNode:_SetName(name)
  local oldName = self.nodeName
  self.nodeName = name
  if self._CreatedDone then
    for _, dispatcherInfo in pairs(self._RefactorList) do
      dispatcherInfo:NameChanged(oldName,  name)
    end
  end
end

function CustomEventNode:GetRefactorList()
  return self._RefactorList;
end


CustomEventNode:MemberRegister("nodeName", Types.StringType(CustomEventNode._GetName, CustomEventNode._SetName))
CustomEventNode:MemberRegister("_inputInfoArray");
-- 不使用只支持序列化的BluePinInfo,使用支持反射和序列化的BlueFunctionPinInfo

CustomEventNode:RegisterExecOutput(1, "exec", "Execute");
CustomEventNode:SetFunctionName("Custom Event");
CustomEventNode:SetFunctionType(BD.CUSTOM_EVENT_NODE);

return CustomEventNode;

