local AE = require "apolloengine"
local BN = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local Resolution = BN:extend();

function Resolution:new(...)
  Resolution.super.new(self, ...)
end

function Resolution:_OnUpdate(args)
  local resolution
  if _KRATOSEDITOR then
    local scene = AE.SceneManager:GetOrCreateScene("facecuteScene"); --previewscene
    local fbo = scene:GetDefaultRenderTarget();
    local tex = fbo:GetAttachment(AE.RenderTargetEntity.TA_COLOR_0);
    resolution = tex:GetSize();
  else
    resolution = AE.Framework:GetResolution();
  end
  return  resolution:x(), resolution:y()
end

Resolution:RegisterOutput(1, Types.FloatType, "width", "width");
Resolution:RegisterOutput(2, Types.FloatType, "height", "height");

Resolution:SetFunctionName("Resolution");
Resolution:SetFunctionType(BD.STATIC_FUNCTION_NODE);
return Resolution ;

