local AE = require "apolloengine"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BlueRtti = require "bluecore.core.blue_rtti"
local BD = require "bluecore.bluedefined"
local RttiOfTE = AE.TextureEntity:RTTI();
local CreateTex2D = BlueNode:extend();
--Unreal Engine: Import File as Texture 2D

---- 游戏运行模式
function CreateTex2D:new(...)
  CreateTex2D.super.new(self, ...)
end

function CreateTex2D:_OnUpdate(args)
  local filepath = args[1]
  self.errorWarning = not filepath and "nil tex path, please check the input path! " or nil;
  filepath = filepath or BD.NilTexPath;
  local entity = BlueRtti.Create(RttiOfTE, filepath)
  return entity;
end

---- 编辑器模式
CreateTex2D:RegisterInput(1, Types.Tex2DPathType, "Tex2D Path", "根据纹理路径创建纹理", "DEVICE_CAPTURE");

CreateTex2D:RegisterOutput(1, RttiOfTE, "Tex", "输出纹理");

CreateTex2D:RegisterExecInput(1, "exec", "执行");

CreateTex2D:RegisterExecOutput(1, "exec", "执行");

CreateTex2D:SetFunctionName("CreateTex2D");

return CreateTex2D ;

