local BN = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local AE = require "apolloengine"
local ED = require "bluecore.eventdispatcher"
local Types = require "venuscore.rtti.types"
local MF = require "mathfunction"

local OnRelease = BN:extend();

function OnRelease:new(...)
  OnRelease.super.new(self, ...)
  self.touchId = 0 ;
end

function OnRelease:_OnUpdate(eventParam)
  local output = eventParam
  if output ~= nil and  output.index == self.touchId then
    self.nextExecIdx = 1
    return output.point
  end
  self.nextExecIdx = 0 -- break exec
end

function OnRelease:_OnNextBranch()
  return self.nextExecIdx
end

function OnRelease:RegisterTriggerFunc(func, bluePrintSelf)

  self.inputArgs = {}
  for key , input in pairs(self.dependInputs) do
    input[1]:Update();
    table.insert(self.inputArgs, input[1]:GetOutputByIndex(input[2]));
  end
  self.touchId = self.inputArgs[1]


  ED:RegisterCallback(
          BD.Event.TouchGlobalPath,
          BD.Event.TouchGlobalEvent.TOUCH_RELEASE ,
          func,
          bluePrintSelf);

  AE.IActionSystem:AddClient(
          AE.SensorsTrackingComponent.VENUS_SENSOR_TOUCH,
          bluePrintSelf.Node:GetComponent(AE.Node.CT_BLUEPRINT), 0);
end

function OnRelease:_OnStop()
  -- ED:RegisterCallback -- Do not Need
  AE.IActionSystem:RemoveClient(
          AE.SensorsTrackingComponent.VENUS_SENSOR_TOUCH,
          self.graph.Node:GetComponent(AE.Node.CT_BLUEPRINT));

end

OnRelease:RegisterInput(1, Types.IntType, "PointerId", "start from 0", 0)
OnRelease:RegisterOutput(1, MF.vector2():RTTI(), "coord", "range [-1,1], screen center is origin, left and top is postive")
OnRelease:RegisterExecOutput(1, "exec", "exec");

OnRelease:SetFunctionName("Touch Release");
OnRelease:SetFunctionType(BD.EVENT_FUNCTION_NODE);
OnRelease:SetEventType(BD.EventType.RegisterCallback);

return OnRelease;
