local Types = require "venuscore.rtti.types"
local BlueDynamicAnyTypePinsNode = require "bluecore.base.blue_dynamic_anytype_pins_node"
local BD = require "bluecore.bluedefined"

local MultiGate = BlueDynamicAnyTypePinsNode:extend();

---- 游戏运行模式
function MultiGate:new(...)
  MultiGate.super.new(self, ...)
  self.execSeq = {}
  self.execIdx = -1
  self.currentIdx = 0
  -- -1 not start
  --  0 one loop end
end

function MultiGate:Update(execIdx)

  if execIdx == nil then
    return ;
  end

  if execIdx == 1 then

    if self.execIdx == -1 or self.execIdx == 0 then

      -- 每个循环结束 才会重新获取值
      local inputs = self:_GetInput();

      local isRandom = inputs[1]
      local isLoop = inputs[2]
      local startIndex = inputs[3]

      if self.execIdx == 0 and isLoop == false then -- loop end
        WARNING("MultiGate(End)")
        return
      end

      local outNums = #self.execOutputs

      -- 只生成一次,只要引脚数目不变,不用重新生成
      -- onRecordStart --ok
      -- ResetPreview  --ok
      if #self.execSeq == 0 then
        --WARNING("Generate Exec Seq .. ")
        if startIndex > 0 then
          startIndex = startIndex - 1 -- start from 1 -> 0
        else
          startIndex = 0  -- -1,0 -> 0
        end
        for i = 0, outNums - 1  do
          table.insert(self.execSeq,  ((i + startIndex) % outNums) + 1)
        end
      end

      if isRandom then
        local half = math.floor(outNums*0.8)
        local offset = math.random(0  ,outNums - half)
        for i = 1, half do
          --math.randomseed(os.time() + i*314159)
          local replace = math.random(1, outNums)
          local old = self.execSeq[i + offset]
          self.execSeq[i + offset] = self.execSeq[replace]
          self.execSeq[replace] = old
        end
      end

      --for i = 1, outNums do
      --  WARNING("i = "..tostring(i)..", "..self.execSeq[i])
      --end

      self.execIdx = 1

      --LOG("outNums "..tostring(outNums))
    end

    local execCurrentIdx = self.execIdx

    self.currentIdx = self.execSeq[self.execIdx]

    self.execIdx =  self.execIdx < #self.execOutputs and self.execIdx + 1 or 0 -- end

    self.outputResults = { execCurrentIdx , self.currentIdx};

    return self.currentIdx;

  else -- Reset
    self:_OnReset();
    -- no return, do not exec any next bluenode
  end
end


function MultiGate:_OnReset()
  -- rebuild self.execSeq = {}
  self.execIdx = -1
end

---- 编辑器模式

-- 在编辑器交互上创建时候回调 (避免数据和反序列化重叠 e.g table.insert操作)
function MultiGate:_OnCreateWithEditor()
  MultiGate.super._OnCreateWithEditor(self);
end

-- 当删除pin的时候,由于pin脚顺序发生改变,回调给具体节点类进行修改
function MultiGate:_OnOrderChange(pinInfo, oldIdx, newIdx)
  pinInfo.name = "Out ["..(newIdx).."]"
  pinInfo.tips = "Out ["..(newIdx).."]"
  WARNING("pinInfo Update "..tostring(pinInfo.name)..","..tostring(pinInfo.tips))
end

MultiGate._OnAdd = function(thisNode)
  local inputInfo = thisNode.infoTable[BD.PIN_EXEC_OUTPUT][1]
  local pinUid = thisNode.graph:_NextID();
  local nodeUid = thisNode.uid;
  local newArgId = 1
  for _ , __ in pairs(thisNode[BD.EXEC_OUTPUTS_INFO]) do
    newArgId = newArgId + 1
  end
  local inputPin = thisNode:AppendExecOutput(Types.ExecPinType, "Out ["..(newArgId).."]", "执行 ["..(newArgId).."]", nil, pinUid, nodeUid, true);

  return inputPin
end

-- 之前已经删除连接信息,索引表在执行完所有删除操作之后才会移除对应pin/node
MultiGate._OnDel = function(thisNode, execOutputPin)
  thisNode:RemoveExecOutput(execOutputPin);
  return true
end


MultiGate:RegisterInput(1, Types.BoolType, "Random", "is Random", false);
MultiGate:RegisterInput(2, Types.BoolType, "Loop", "is Loop", false);
MultiGate:RegisterInput(3, Types.IntType, "Start Index", "start index", -1);

MultiGate:RegisterOutput(1, Types.IntType, "Order Index", "order index(random)");
MultiGate:RegisterOutput(2, Types.IntType, "Exec Index", "execute index(sequence)");

MultiGate:RegisterExecInput(1, "exec", "Execute");
MultiGate:RegisterExecInput(2, "Reset", "Reset", true) -- true-abort
MultiGate:RegisterExecOutput(1, "Out [1]", "Exec 1");
MultiGate:RegisterExecOutput(2, "Out [2]", "Exec 2");

MultiGate:RegisterMoreExecOutput("exec", BD.OP_ADD, "增加输出执行节点引脚", MultiGate._OnAdd, BD.OP_DEL, "删除输出执行节点引脚", MultiGate._OnDel);
MultiGate:SetFunctionName("MultiGate");

return MultiGate;

