local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local GetScriptValue = require "bluecore.base.get_script_value"
local GetScriptVector1 = GetScriptValue:extend();


---- vector1和number都放这里 统一输出vector1
function GetScriptVector1:new(...)
  GetScriptVector1.super.new(self, ...)

end

function GetScriptVector1:_OnUpdate(args)

  local scriptIns = args[1];
  local para = args[2];
  local val = scriptIns:GetScriptValue(para);
  return type(val) == "userdata" and val or mathfunction.vector1(val);
end



function GetScriptVector1:_IsRightType(key, value, scriptIns)
  local isVec1 = type(value) == "userdata" and value:RTTI() == mathfunction.vector1:RTTI();
  local isNum = type(value) == "number";
  return isVec1 or isNum;
end



GetScriptVector1:RegisterInput(1, Types.ScriptInsRefType, "Script_Instance", "behaviour", Types.NotNullType());
GetScriptVector1:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING);

GetScriptVector1:RegisterOutput(1, mathfunction.vector1:RTTI(), "vector1", "获取参数值");


GetScriptVector1:SetFunctionName("GetScriptVector1");


return GetScriptVector1 ;

