local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local BreakFaceAttr = BlueNode:extend();

function BreakFaceAttr:new(...)
  BreakFaceAttr.super.new(self, ...)
end

function BreakFaceAttr:_OnUpdate(args)
  local faceAttr = args[1];
  if faceAttr == nil then
    return  0, 0, 0, 0, 0, 0, 0
  else
    return faceAttr.man,
            faceAttr.yellow,
            faceAttr.black,
            faceAttr.white,
            faceAttr.india,
            faceAttr.age,
            faceAttr.beauty
  end
end

BreakFaceAttr:RegisterInput(1, Types.FaceAttributeType, "FaceAttribute", "人脸属性", nil);

-- RecognitionComponent:_StructFaceAttributeData
BreakFaceAttr:RegisterOutput(1, Types.FloatType, "man", "score >0.5 is man");
BreakFaceAttr:RegisterOutput(2, Types.FloatType, "yellow", "yellow score");
BreakFaceAttr:RegisterOutput(3, Types.FloatType, "black", "black score");
BreakFaceAttr:RegisterOutput(4, Types.FloatType, "white", "white score");
BreakFaceAttr:RegisterOutput(5, Types.FloatType, "india", "india score");
BreakFaceAttr:RegisterOutput(6, Types.FloatType, "age", "age ");
BreakFaceAttr:RegisterOutput(7, Types.FloatType, "beauty", "beauty score");
BreakFaceAttr:SetFunctionName("Break Face Attribute");

return BreakFaceAttr;

