local pnp = require "pnpestimates"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local GetHeadId = BlueNode:extend();

function GetHeadId:new(...)
  GetHeadId.super.new(self, ...)
end

function GetHeadId:_OnUpdate(args)
  local comp = args[1];
  local id = 0
  if comp ~= nil then
    id =  comp.HeadID
  end
  return id
end

GetHeadId:RegisterInput(1, pnp.HeadTrackComponent:RTTI(), "target", "HeaderTracking组件", BlueSelf());
GetHeadId:RegisterOutput(1, Types.IntType, "Head ID", "head id(从0开始)");
GetHeadId:SetFunctionName("Get Head ID");
GetHeadId:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return GetHeadId;

