local apolloengine = require "apolloengine"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"

local Loop = BlueNode:extend();

---- 游戏运行模式
function Loop:new(...)
  Loop.super.new(self, ...)
end

function Loop:_OnUpdate(args)
  local FrameAniEntity = args[1].aniEntityArray;
  for i=1, #FrameAniEntity do
  	FrameAniEntity[i].isloop = args[2];
  end
end

---- 编辑器模式
Loop:RegisterInput(1, apolloengine.FrameAnimationComponent:RTTI(), "target", "FrameAnimationComponent组件", BlueSelf());
Loop:RegisterInput(2, Types.BoolType, "isLoop", "设置循环状态", true);

Loop:RegisterExecInput(1, "exec", "执行");

Loop:RegisterExecOutput(1, "exec", "执行");

Loop:SetFunctionName("FrameAniLoop");

return Loop;

