local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "libvenuscore"
local MemberIterator = require "venuscore.rtti.mpairs"
local BlueSelf = require "bluecore.blueself"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local BlueNode = require "bluecore.bluenode"
local BluePinInfo = require "bluecore.bluepininfo"
local SetPostEffectValue = BlueNode:extend();


---- 游戏运行模式
function SetPostEffectValue:new(...)
  SetPostEffectValue.super.new(self, ...)
end

function SetPostEffectValue:_SetupInstanceInfoTable()

  -- infoTable 在bluenode不会被序列化出去 
  -- 反射同类型的所有参数作为数据引脚2的枚举选择 需要重写infoTable
  local staticExecInputsInfo = self.infoTable[BD.PIN_EXEC_INPUT]
  local staticExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]
  local staticDataOutputsInfo = self.infoTable[BD.PIN_DATA_OUTPUT]
  local staticDataInputsInfo = self.infoTable[BD.PIN_DATA_INPUT]
  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}
  self.infoTable[BD.PIN_DATA_OUTPUT] = staticDataOutputsInfo -- 并不会动态修改 data output info
  self.infoTable[BD.PIN_EXEC_INPUT]  = staticExecInputsInfo
  self.infoTable[BD.PIN_EXEC_OUTPUT] = staticExecOutputsInfo


  self.myUnFixComboType = Types.ClassifyType:extend();
  self.myUnFixComboType:SetData({},{});

  local pinInfo = staticDataInputsInfo[1]
  self.infoTable[BD.PIN_DATA_INPUT][1] =  staticDataInputsInfo[1]
  pinInfo = staticDataInputsInfo[2]
  self.infoTable[BD.PIN_DATA_INPUT][2] = BluePinInfo(BD.PIN_DATA_INPUT, pinInfo.argId, self.myUnFixComboType, pinInfo.name,pinInfo.tips,pinInfo.default,pinInfo.delAble, pinInfo.groupName);
  pinInfo = staticDataInputsInfo[3]
  self.infoTable[BD.PIN_DATA_INPUT][3] =  staticDataInputsInfo[3]

end

function SetPostEffectValue:_IsRightType(value)
  return true;
end

function SetPostEffectValue:_OnUpdate(args)
  args[1]:SetParameter(args[2], args[3]);
end

--更新可选参数   
--mark _OnUpdateByEditor 调用到这里来scene的可选枚举会及时修正（删除后处理的时候）~
--字面值二者保持一致
function SetPostEffectValue:SetParaEnum(postEffectRefNode)
  
  if postEffectRefNode:GetFunctionType() == BD.COMPONENT_CONTENT_NODE then
    if not venuscore.isNil(postEffectRefNode.comp) 
      and not venuscore.isNil(postEffectRefNode.postEffect) then
        local ktbl = {};
        local vtbl = {};
        local parameters = postEffectRefNode.postEffect.Parameters;
        for k,v in pairs(parameters) do
          if self:_IsRightType(v) then
            table.insert(ktbl, k);
            table.insert(vtbl, k);
          end
        end
        self.myUnFixComboType:SetData(ktbl, vtbl);
    else
      self.myUnFixComboType:SetData({}, {});
    end
  end
  -- body
end

--反序列化恢復菜單
function SetPostEffectValue:_OnDeserializePost()
  SetPostEffectValue.super._OnDeserialize(self);
  self:_SetupInstanceInfoTable();
end


function SetPostEffectValue:_OnCompile()
  self.compileResult = nil;
  if SetPostEffectValue.super._OnCompile(self) then

    --Step1 输入检查
    if #self.inputs[1].links ~= 0 then
      local bluePinLink = self.inputs[1].links[1]; -- 输入引脚只允许一个连接
      local otherNode = self.graph:GetNode(bluePinLink.nodeUid);

      if venuscore.isNil(otherNode.comp) then
        self.compileResult = BD.EHINT.COMP_LOST;
        return false;
      end

      if venuscore.isNil(otherNode.postEffect) then
        self.compileResult = BD.EHINT.POSTEFFECT_NOT_EXIST;
        return false;
      end


      --Step 2字符串为BD.EMPTY_STRING会报错
      if self.inputs[2].literal == BD.EMPTY_STRING then
        self.compileResult = BD.EHINT.ERROR_PARA;
        return false;
      end

    else
      self.compileResult = BD.EHINT.PIN_1_EMPTY;
      return false;
    end

    return true;

  end

  return false;
 
end


---------编辑器模式
if _KRATOSEDITOR then


  function SetPostEffectValue:_OnLink(selfPin, otherNode, otherPin)
    self:SetParaEnum(otherNode);
  end

  function SetPostEffectValue:_OnUnLink(unlinkPin) --这个时候传入pin  里面的link信息已经在blueprint被删了
    if next(self.inputs[1].links) == nil then
      self.myUnFixComboType:SetData({}, {});
      self.inputs[2].literal = BD.EMPTY_STRING;
      --self.recalllink = selfPin.links[1].linkUid;
    end
  end

  function SetPostEffectValue:_OnCreateWithEditor()
    SetPostEffectValue.super._OnCreateWithEditor(self);
    self:_SetupInstanceInfoTable();
  end

  --scene窗口调用 game窗口不调用
  function SetPostEffectValue:_OnUpdateByEditor()
    SetPostEffectValue.super._OnUpdateByEditor(self);
    if next(self.inputs[1].links) ~= nil then
      local bluePinLink = self.inputs[1].links[1]; 
      local otherNode = self.graph:GetNode(bluePinLink.nodeUid);
      self:SetParaEnum(otherNode);
    end
    -- body
  end

end


return SetPostEffectValue ;

