require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"

local smooth = {}

smooth.renderObject = nil;
smooth.queue = 100;

function smooth:Initialize(host, size)

  self.Stepsize1 = mathfunction.vector2(5, 5);
  self.Stepsize2 = mathfunction.vector2(2, 2);
  self.intensity = 1.0;
  self.size = size;
  
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");
   
  self.TEXTURE_ORIGIN = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_ORIGIN");
  
  self.TEXTURE_BLUR = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR");
  self.TEXTURE_MASK = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_MASK");
  self.UNIFORM_INTENSITY = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_INTENSITY");
  
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  
  self.RoGuassX = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
  self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), 0) );
  
  self.RoGuassY = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
  self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep1:y()) );
  
  self.HighPass = host:CreateRenderObject( "comm:documents/material/highpass.material" );
  
  self.SkinDetect = host:CreateRenderObject("comm:documents/material/skindetect.material")
  
  self.SkinGuassX = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );  --对mask做模糊，平滑边缘
  self.SkinGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), 0 ) );
  
  self.SkinGuassY = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
  self.SkinGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep2:y()) );
  
  self.Blend = host:CreateRenderObject( "comm:documents/material/smoothblend.material" );
  self.Blend:SetParameter( self.UNIFORM_INTENSITY, mathfunction.vector1(self.intensity) );
  
  self.GuassXRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );
  self.OriBlurRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size );
  self.highpassRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_C, size );
  self.HpBlurRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_D, size );
  self.skinRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_E, size );
  
  return self.queue;
end

function smooth:Resizeview(size)
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  self.size = size;
  self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), 0 ) );
  self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep1:y() ) );
  self.SkinGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(),0 ) );
  self.SkinGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0,GuassStep2:y() ) );
end

function smooth:Process(pipeline, Original, Scene, Output)
  local origintexture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  self.HighPass:SetParameter(self.TEXTURE_ORIGIN, origintexture);
  self:_UpdateParameters();
  
  self.GuassXRT:PushRenderTarget();
	self.GuassXRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassX:Draw(pipeline);
  
  self.OriBlurRT:PushRenderTarget();
	self.OriBlurRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.GuassXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassY:Draw(pipeline);
  
  local blurtex = self.OriBlurRT:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.highpassRT:PushRenderTarget();
  self.highpassRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.HighPass:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          self.OriBlurRT:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
  self.HighPass:Draw(pipeline);
  
  self.GuassXRT:PushRenderTarget();
  self.GuassXRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.highpassRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.RoGuassX:Draw(pipeline);
  
  self.HpBlurRT:PushRenderTarget();
  self.HpBlurRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.RoGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.GuassXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.RoGuassY:Draw(pipeline);
 
  self.skinRT:PushRenderTarget();
  self.skinRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.SkinDetect:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		origintexture);
  self.SkinDetect:Draw(pipeline);
  
  self.GuassXRT:PushRenderTarget();
  self.GuassXRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.SkinGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.skinRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.SkinGuassX:Draw(pipeline);
  
  self.skinRT:PushRenderTarget();
  self.skinRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.SkinGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.GuassXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  self.SkinGuassY:Draw(pipeline);
  
  self.Blend:SetParameter( self.TEXTURE_ORIGIN,origintexture);
  self.Blend:SetParameter( self.TEXTURE_BLUR,blurtex);
  self.Blend:SetParameter( self.TEXTURE_MASK,self.skinRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ))
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.Blend:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.HpBlurRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.Blend:Draw(pipeline);
end

function smooth:_UpdateParameters()
 self.Blend:SetParameter( self.UNIFORM_INTENSITY, mathfunction.vector1(self.intensity) );
end

return smooth;